/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.jackson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.linguafranca.pwdb.base.AbstractGroup;
import org.linguafranca.pwdb.kdbx.jackson.JacksonDatabase;
import org.linguafranca.pwdb.kdbx.jackson.JacksonEntry;
import org.linguafranca.pwdb.kdbx.jackson.JacksonIcon;
import org.linguafranca.pwdb.kdbx.jackson.converter.Base64ToUUIDConverter;
import org.linguafranca.pwdb.kdbx.jackson.converter.BooleanToStringConverter;
import org.linguafranca.pwdb.kdbx.jackson.converter.StringToBooleanConverter;
import org.linguafranca.pwdb.kdbx.jackson.converter.UUIDToBase64Converter;
import org.linguafranca.pwdb.kdbx.jackson.model.KeePassFile;
import org.linguafranca.pwdb.kdbx.jackson.model.Times;

@JsonPropertyOrder(value={"uuid", "name", "notes", "iconID", "customIconUUID", "times", "isExpanded", "defaultAutoTypeSequence", "enableAutoType", "enableSearching", "lastTopVisibleEntry", "previousParentGroup", "tags", "customData", "entry", "group"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class JacksonGroup
extends AbstractGroup<JacksonDatabase, JacksonGroup, JacksonEntry, JacksonIcon> {
    @JacksonXmlProperty(localName="UUID")
    @JsonDeserialize(converter=Base64ToUUIDConverter.class)
    @JsonSerialize(converter=UUIDToBase64Converter.class)
    protected UUID uuid;
    @JacksonXmlProperty(localName="Name")
    protected String name;
    @JacksonXmlProperty(localName="Notes")
    protected String notes;
    @JacksonXmlProperty(localName="IconID")
    protected int iconID;
    @JacksonXmlProperty(localName="CustomIconUUID")
    @JsonDeserialize(converter=Base64ToUUIDConverter.class)
    @JsonSerialize(converter=UUIDToBase64Converter.class)
    protected UUID customIconUuid;
    @JacksonXmlProperty(localName="Times")
    protected Times times;
    @JacksonXmlProperty(localName="IsExpanded")
    @JsonDeserialize(converter=StringToBooleanConverter.class)
    @JsonSerialize(converter=BooleanToStringConverter.class)
    protected Boolean isExpanded;
    @JacksonXmlProperty(localName="DefaultAutoTypeSequence")
    protected String defaultAutoTypeSequence;
    @JacksonXmlProperty(localName="EnableAutoType")
    @JsonDeserialize(converter=StringToBooleanConverter.class)
    @JsonSerialize(converter=BooleanToStringConverter.class)
    protected Boolean enableAutoType;
    @JacksonXmlProperty(localName="EnableSearching")
    @JsonDeserialize(converter=StringToBooleanConverter.class)
    @JsonSerialize(converter=BooleanToStringConverter.class)
    protected Boolean enableSearching;
    @JacksonXmlProperty(localName="LastTopVisibleEntry")
    @JsonDeserialize(converter=Base64ToUUIDConverter.class)
    @JsonSerialize(converter=UUIDToBase64Converter.class)
    protected UUID lastTopVisibleEntry;
    @JacksonXmlProperty(localName="PreviousParentGroup")
    @JsonDeserialize(converter=Base64ToUUIDConverter.class)
    @JsonSerialize(converter=UUIDToBase64Converter.class)
    protected UUID previousParentGroup;
    @JacksonXmlProperty(localName="Tags")
    protected String tags;
    @JacksonXmlProperty(localName="CustomData")
    protected KeePassFile.CustomData customData;
    @JacksonXmlProperty(localName="Entry")
    @JacksonXmlElementWrapper(useWrapping=false)
    protected List<JacksonEntry> entries = new ArrayList<JacksonEntry>();
    @JacksonXmlProperty(localName="Group")
    @JacksonXmlElementWrapper(useWrapping=false)
    protected List<JacksonGroup> groups = new ArrayList<JacksonGroup>();
    @JsonIgnore
    protected JacksonDatabase database;
    @JsonIgnore
    protected JacksonGroup parent;

    public JacksonGroup() {
        this.times = new Times();
    }

    public static JacksonGroup createGroup(JacksonDatabase database) {
        JacksonGroup group = new JacksonGroup();
        group.database = database;
        group.iconID = 0;
        group.name = "";
        group.uuid = UUID.randomUUID();
        return group;
    }

    public boolean isRootGroup() {
        return ((Object)((Object)this.database.getRootGroup())).equals((Object)this);
    }

    public boolean isRecycleBin() {
        return this.database.keePassFile.meta.recycleBinUUID.equals(this.uuid);
    }

    public JacksonGroup getParent() {
        return this.parent;
    }

    public void setParent(JacksonGroup g) {
        JacksonGroup group = g;
        if (this.isRootGroup()) {
            throw new IllegalStateException("Cannot add root group to another group");
        }
        if (this.database != group.database) {
            throw new IllegalStateException("Must be from same database");
        }
        if (this.parent != null) {
            this.parent.removeGroup(group);
            this.parent.touch();
        }
        this.parent = group;
        this.parent.touch();
        this.touch();
    }

    public List<JacksonGroup> getGroups() {
        return new ArrayList<JacksonGroup>(this.groups);
    }

    @JsonIgnore
    public int getGroupsCount() {
        return this.groups.size();
    }

    public JacksonGroup addGroup(JacksonGroup g) {
        JacksonGroup group = g;
        if (group.isRootGroup()) {
            throw new IllegalStateException("Cannot add root group to another group");
        }
        if (this.database != group.database) {
            throw new IllegalStateException("Must be from same database");
        }
        if (group.getParent() != null) {
            group.getParent().removeGroup(group);
        }
        group.parent = this;
        this.groups.add(group);
        this.touch();
        return group;
    }

    public JacksonGroup removeGroup(JacksonGroup g) {
        JacksonGroup group = g;
        if (this.database != group.database) {
            throw new IllegalStateException("Must be from same database");
        }
        this.groups.remove((Object)group);
        group.parent = null;
        this.touch();
        return group;
    }

    public List<JacksonEntry> getEntries() {
        return new ArrayList<JacksonEntry>(this.entries);
    }

    @JsonIgnore
    public int getEntriesCount() {
        return this.entries.size();
    }

    public JacksonEntry addEntry(JacksonEntry e) {
        JacksonEntry entry = e;
        if (this.database != entry.database) {
            throw new IllegalStateException("Must be from same database");
        }
        if (entry.getParent() != null) {
            entry.getParent().removeEntry(entry);
        }
        this.entries.add(entry);
        entry.parent = this;
        this.touch();
        return entry;
    }

    public JacksonEntry removeEntry(JacksonEntry e) {
        JacksonEntry entry = e;
        if (this.database != entry.database) {
            throw new IllegalStateException("Must be from same database");
        }
        this.entries.remove((Object)entry);
        entry.parent = null;
        return entry;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
        this.touch();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public JacksonIcon getIcon() {
        return new JacksonIcon(this.iconID);
    }

    public void setIcon(JacksonIcon icon) {
        this.iconID = icon.getIndex();
        this.touch();
    }

    @NotNull
    public JacksonDatabase getDatabase() {
        return this.database;
    }

    private void touch() {
        if (this.times != null) {
            this.times.setLastModificationTime(new Date());
        }
        if (this.database != null) {
            this.database.setDirty(true);
        }
    }
}

