/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.jackson.converter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.linguafranca.pwdb.PropertyValue;
import org.linguafranca.pwdb.security.StreamEncryptor;

public class ValueSerializer
extends StdSerializer<PropertyValue> {
    private final StreamEncryptor encryptor;
    private final PropertyValue.Strategy propertyValueStrategy;

    public ValueSerializer(StreamEncryptor encryptor, PropertyValue.Strategy propertyValueStrategy) {
        super(ValueSerializer.class, false);
        this.encryptor = encryptor;
        this.propertyValueStrategy = propertyValueStrategy;
    }

    private String encrypt(byte[] bytes) {
        byte[] encrypted = this.encryptor.encrypt(bytes);
        return new String(Base64.encodeBase64((byte[])encrypted));
    }

    public void serialize(PropertyValue value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        String stringToWrite;
        ToXmlGenerator xmlGenerator = (ToXmlGenerator)gen;
        xmlGenerator.writeStartObject();
        String string = stringToWrite = value.isProtected() ? this.encrypt(value.getValueAsBytes()) : value.getValueAsString();
        if (value.isProtected()) {
            xmlGenerator.setNextIsAttribute(true);
            xmlGenerator.writeStringField("Protected", "True");
        }
        xmlGenerator.setNextIsAttribute(false);
        xmlGenerator.setNextIsUnwrapped(true);
        xmlGenerator.writeStringField("text", stringToWrite);
        xmlGenerator.writeEndObject();
    }
}

