/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdb;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import org.bouncycastle.util.encoders.Hex;
import org.linguafranca.pwdb.Credentials;
import org.linguafranca.pwdb.security.Encryption;

public interface KdbCredentials
extends Credentials {

    public static class KeyFile
    implements KdbCredentials {
        private final byte[] key;

        public KeyFile(byte[] password, InputStream inputStream) {
            MessageDigest md = Encryption.getSha256MessageDigestInstance();
            byte[] pwKey = md.digest(password);
            md.update(pwKey);
            try {
                byte[] keyFileData = ByteStreams.toByteArray((InputStream)inputStream);
                if (keyFileData.length == 64) {
                    keyFileData = Hex.decode((byte[])keyFileData);
                    this.key = md.digest(keyFileData);
                    return;
                }
                throw new IllegalStateException("Invalid length key file " + keyFileData.length);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not read key file", e);
            }
        }

        public byte[] getKey() {
            return this.key;
        }
    }

    public static class Password
    implements KdbCredentials {
        private final byte[] key;

        public Password(byte[] password) {
            MessageDigest md = Encryption.getSha256MessageDigestInstance();
            this.key = md.digest(password);
        }

        public byte[] getKey() {
            return this.key;
        }
    }
}

