/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.hashedblock;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public class CollectingOutputStream
extends FilterOutputStream {
    private final ByteArrayOutputStream collectedBytes = new ByteArrayOutputStream();
    private boolean collecting = true;

    public CollectingOutputStream(OutputStream out) {
        this(out, true);
    }

    public CollectingOutputStream(OutputStream out, boolean collecting) {
        super(out);
        this.collecting = collecting;
    }

    @Override
    public void write(int toWrite) throws IOException {
        super.write(toWrite);
        if (this.collecting) {
            this.collectedBytes.write(toWrite);
        }
    }

    @Override
    public void write(byte @NotNull [] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte @NotNull [] b, int off, int len) throws IOException {
        super.write(b, off, len);
    }

    public byte[] getCollectedBytes() {
        return this.collectedBytes.toByteArray();
    }

    public boolean isCollecting() {
        return this.collecting;
    }

    public void setCollecting(boolean collecting) {
        this.collecting = collecting;
    }
}

