/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.hashedblock;

import com.google.common.io.LittleEndianDataOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import javax.crypto.Mac;
import org.jetbrains.annotations.NotNull;
import org.linguafranca.pwdb.kdbx.Helpers;
import org.linguafranca.pwdb.security.Encryption;

public class HmacBlockOutputStream
extends FilterOutputStream {
    private static final int BLOCK_SIZE = (int)Math.pow(2.0, 20.0);
    private final byte[] key;
    private final ByteArrayOutputStream outputBuffer = new ByteArrayOutputStream();
    private final DataOutput output;
    private final ByteOrder byteOrder;
    private long nextSequenceNumber = 0L;
    private boolean isClosed = false;

    public HmacBlockOutputStream(byte[] key, OutputStream outputStream) throws IOException {
        this(key, outputStream, false);
    }

    public HmacBlockOutputStream(byte[] key, OutputStream outputStream, boolean littleEndian) throws IOException {
        super(outputStream);
        this.key = key;
        this.byteOrder = littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        this.output = this.byteOrder.equals(ByteOrder.LITTLE_ENDIAN) ? new LittleEndianDataOutputStream(this.out) : new DataOutputStream(this.out);
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            throw new EOFException();
        }
        this.flush();
        this.writeBlock(new byte[0]);
        this.out.flush();
        this.out.close();
        this.isClosed = true;
    }

    private void writeBlock(byte[] buffer) throws IOException {
        byte[] transformedKey = Encryption.transformHmacKey((byte[])this.key, (byte[])Helpers.toBytes(this.nextSequenceNumber, this.byteOrder));
        Mac mac = Encryption.getHMacSha256Instance((byte[])transformedKey);
        mac.update(Helpers.toBytes(this.nextSequenceNumber++, this.byteOrder));
        mac.update(Helpers.toBytes(buffer.length, this.byteOrder));
        mac.update(buffer);
        byte[] finalMac = mac.doFinal();
        this.output.write(finalMac);
        this.output.writeInt(buffer.length);
        this.output.write(buffer);
        this.out.flush();
    }

    protected void put(byte[] b, int offset, int length) throws IOException {
        if (this.isClosed) {
            throw new EOFException();
        }
        while (length > 0) {
            int bytesToWrite = Math.min(BLOCK_SIZE - this.outputBuffer.size(), length);
            this.outputBuffer.write(b, offset, bytesToWrite);
            if (this.outputBuffer.size() >= BLOCK_SIZE) {
                this.save();
            }
            offset += bytesToWrite;
            length -= bytesToWrite;
        }
    }

    protected void save() throws IOException {
        if (this.outputBuffer.size() == 0) {
            return;
        }
        this.writeBlock(this.outputBuffer.toByteArray());
        this.outputBuffer.reset();
    }

    @Override
    public void write(int i) throws IOException {
        byte[] buf = new byte[]{(byte)i};
        this.put(buf, 0, 1);
    }

    @Override
    public void write(byte @NotNull [] b, int offset, int count) throws IOException {
        this.put(b, offset, count);
    }

    @Override
    public void flush() throws IOException {
        this.save();
    }
}

