/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.crypto.Mac;
import org.linguafranca.pwdb.Credentials;
import org.linguafranca.pwdb.StreamConfiguration;
import org.linguafranca.pwdb.security.Aes;
import org.linguafranca.pwdb.security.ChaCha;
import org.linguafranca.pwdb.security.CipherAlgorithm;
import org.linguafranca.pwdb.security.Encryption;
import org.linguafranca.pwdb.security.KeyDerivationFunction;
import org.linguafranca.pwdb.security.StreamEncryptor;
import org.linguafranca.pwdb.security.VariantDictionary;

public class KdbxHeader
implements StreamConfiguration {
    private final List<Integer> allowableVersions = new ArrayList<Integer>(Arrays.asList(3, 4));
    private int version;
    protected UUID cipherUuid;
    private byte[] masterSeed;
    private byte[] encryptionIv;
    private CompressionFlags compressionFlags;
    private byte[] transformSeed;
    private long transformRounds;
    private byte[] innerRandomStreamKey;
    private Encryption.ProtectedStreamAlgorithm protectedStreamAlgorithm;
    private CipherAlgorithm cipherAlgorithm;
    private KeyDerivationFunction keyDerivationFunction;
    private byte[] streamStartBytes;
    private VariantDictionary kdfParameters;
    private VariantDictionary customData;
    List<byte[]> binaries = new ArrayList<byte[]>();
    private byte[] headerHash;
    private byte[] headerBytes;
    public static SecureRandom random;

    public KdbxHeader() {
        this(KdbxHeaderOpts.V3_AES_SALSA_20);
    }

    public KdbxHeader(int version) {
        this(version == 3 ? KdbxHeaderOpts.V3_AES_SALSA_20 : KdbxHeaderOpts.V4_AES_ARGON_CHA_CHA);
    }

    public KdbxHeader(KdbxHeaderOptions opts) {
        this.version = opts.getVersion();
        this.setCipherAlgorithm(opts.getCipherAlgorithm());
        this.setKeyDerivationFunction(opts.getKeyDerivationFunction());
        this.setProtectedStreamAlgorithm(opts.getProtectedStreamAlgorithm());
        this.cipherUuid = opts.getCipherAlgorithm().getCipherUuid();
        this.compressionFlags = CompressionFlags.GZIP;
        this.masterSeed = random.generateSeed(32);
        this.transformSeed = random.generateSeed(32);
        this.transformRounds = 6000L;
        this.encryptionIv = random.generateSeed(16);
        this.innerRandomStreamKey = random.generateSeed(32);
        this.streamStartBytes = new byte[32];
    }

    public byte[] getHmacKey(Credentials credentials) {
        MessageDigest md = Encryption.getSha512MessageDigestInstance();
        md.update(this.getMasterSeed());
        md.update(this.getTransformedKeyDigest(credentials.getKey()));
        return md.digest(new byte[]{1});
    }

    public void verifyHeaderHmac(byte[] key, byte[] bytes) {
        Mac mac = Encryption.getHMacSha256Instance((byte[])key);
        byte[] computedHmacSha256 = mac.doFinal(this.getHeaderBytes());
        if (!Arrays.equals(computedHmacSha256, bytes)) {
            throw new IllegalStateException("Header HMAC does not match");
        }
    }

    public InputStream createDecryptedStream(byte[] digest, InputStream inputStream) {
        MessageDigest md = Encryption.getSha256MessageDigestInstance();
        md.update(this.masterSeed);
        byte[] finalKeyDigest = md.digest(this.getTransformedKeyDigest(digest));
        CipherAlgorithm ca = Encryption.Cipher.getCipherAlgorithm((UUID)this.cipherUuid);
        return ca.getDecryptedInputStream(inputStream, finalKeyDigest, this.encryptionIv);
    }

    public StreamEncryptor getInnerStreamEncryptor() {
        return Encryption.ProtectedStreamAlgorithm.getStreamEncryptor((Encryption.ProtectedStreamAlgorithm)this.getProtectedStreamAlgorithm(), (byte[])this.getInnerRandomStreamKey());
    }

    public byte[] getTransformedKeyDigest(byte[] digest) {
        if (this.kdfParameters == null) {
            return Aes.getTransformedKey((byte[])digest, (byte[])this.transformSeed, (long)this.transformRounds);
        }
        KeyDerivationFunction kdf = Encryption.KeyDerivationFunction.getKdf((UUID)this.kdfParameters.mustGet("$UUID").asUuid());
        return kdf.getTransformedKey(digest, this.kdfParameters);
    }

    public OutputStream createEncryptedStream(byte[] digest, OutputStream outputStream) {
        MessageDigest md = Encryption.getSha256MessageDigestInstance();
        md.update(this.masterSeed);
        byte[] finalKeyDigest = md.digest(this.getTransformedKeyDigest(digest));
        return this.cipherAlgorithm.getEncryptedOutputStream(outputStream, finalKeyDigest, this.getEncryptionIv());
    }

    public byte[] getTransformSeed() {
        if (this.version < 4) {
            return this.transformSeed;
        }
        return this.kdfParameters.mustGet("S").asByteArray();
    }

    public long getTransformRounds() {
        if (this.version < 4) {
            return this.transformRounds;
        }
        return this.kdfParameters.mustGet("R").asLong();
    }

    public UUID getCipherUuid() {
        return this.cipherUuid;
    }

    public CompressionFlags getCompressionFlags() {
        return this.compressionFlags;
    }

    public byte[] getMasterSeed() {
        return this.masterSeed;
    }

    public byte[] getEncryptionIv() {
        return this.encryptionIv;
    }

    public byte[] getInnerRandomStreamKey() {
        return this.innerRandomStreamKey;
    }

    public byte[] getStreamStartBytes() {
        return this.streamStartBytes;
    }

    public CipherAlgorithm getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public KeyDerivationFunction getKeyDerivationFunction() {
        return this.keyDerivationFunction;
    }

    public Encryption.ProtectedStreamAlgorithm getProtectedStreamAlgorithm() {
        return this.protectedStreamAlgorithm;
    }

    public byte[] getHeaderHash() {
        return this.headerHash;
    }

    public int getVersion() {
        return this.version;
    }

    public VariantDictionary getKdfParameters() {
        return this.kdfParameters;
    }

    public StreamEncryptor getStreamEncryptor() {
        return Encryption.ProtectedStreamAlgorithm.getStreamEncryptor((Encryption.ProtectedStreamAlgorithm)this.getProtectedStreamAlgorithm(), (byte[])this.innerRandomStreamKey);
    }

    public void setCompressionFlags(int flags) {
        this.compressionFlags = CompressionFlags.values()[flags];
    }

    public void setMasterSeed(byte[] masterSeed) {
        this.masterSeed = masterSeed;
    }

    public void setTransformSeed(byte[] transformSeed) {
        this.transformSeed = transformSeed;
    }

    public void setTransformRounds(long transformRounds) {
        this.transformRounds = transformRounds;
    }

    public void setEncryptionIv(byte[] encryptionIv) {
        this.encryptionIv = encryptionIv;
    }

    public void setInnerRandomStreamKey(byte[] key) {
        this.innerRandomStreamKey = key;
    }

    public void setStreamStartBytes(byte[] streamStartBytes) {
        this.streamStartBytes = streamStartBytes;
    }

    public void setInnerRandomStreamId(int innerRandomStreamId) {
        this.protectedStreamAlgorithm = Encryption.ProtectedStreamAlgorithm.getAlgorithm((int)innerRandomStreamId);
    }

    public void setProtectedStreamAlgorithm(Encryption.ProtectedStreamAlgorithm protectedStreamAlgorithm) {
        this.protectedStreamAlgorithm = protectedStreamAlgorithm;
    }

    public void setKeyDerivationFunction(KeyDerivationFunction keyDerivationFunction) {
        this.keyDerivationFunction = keyDerivationFunction;
        if (this.version > 3) {
            this.kdfParameters = this.keyDerivationFunction.createKdfParameters();
        }
    }

    public void setCipherAlgorithm(CipherAlgorithm cipherAlgorithm) {
        this.cipherAlgorithm = cipherAlgorithm;
        this.setCipherUuid(this.cipherAlgorithm.getCipherUuid());
        if (cipherAlgorithm.getName().equals("CHA_CHA_20")) {
            this.encryptionIv = random.generateSeed(12);
        }
    }

    public void setCipherUuid(byte[] uuid) {
        ByteBuffer b = ByteBuffer.wrap(uuid);
        UUID incoming = new UUID(b.getLong(), b.getLong(8));
        this.setCipherUuid(incoming);
        this.cipherAlgorithm = Encryption.Cipher.getCipherAlgorithm((UUID)incoming);
    }

    public void setCipherUuid(UUID uuid) {
        if (!uuid.equals(Aes.getInstance().getCipherUuid()) && !uuid.equals(ChaCha.getInstance().getCipherUuid())) {
            throw new IllegalStateException("Unknown Cipher UUID " + uuid);
        }
        this.cipherUuid = uuid;
    }

    public void setHeaderHash(byte[] headerHash) {
        this.headerHash = headerHash;
    }

    public void setVersion(int version) {
        if (!this.allowableVersions.contains(version)) {
            throw new IllegalStateException("File version must be in " + this.allowableVersions);
        }
        this.version = version;
    }

    public void setKdfParameters(VariantDictionary kdfParameters) {
        this.kdfParameters = kdfParameters;
        this.keyDerivationFunction = Encryption.KeyDerivationFunction.getKdf((UUID)kdfParameters.get("$UUID").asUuid());
    }

    public void setCustomData(VariantDictionary customData) {
        this.customData = customData;
    }

    public void addBinary(byte[] bytes) {
        this.binaries.add(bytes);
    }

    public List<byte[]> getBinaries() {
        return this.binaries;
    }

    public byte[] getHeaderBytes() {
        return this.headerBytes;
    }

    public void setHeaderBytes(byte[] headerBytes) {
        byte[] copy = new byte[headerBytes.length];
        System.arraycopy(headerBytes, 0, copy, 0, headerBytes.length);
        this.headerBytes = copy;
    }

    static {
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            random = new SecureRandom();
        }
    }

    static enum KdbxHeaderOpts implements KdbxHeaderOptions
    {
        V3_AES_SALSA_20(3, Encryption.Cipher.AES, Encryption.KeyDerivationFunction.AES, Encryption.ProtectedStreamAlgorithm.SALSA_20),
        V4_AES_ARGON_CHA_CHA(4, Encryption.Cipher.AES, Encryption.KeyDerivationFunction.ARGON2, Encryption.ProtectedStreamAlgorithm.CHA_CHA_20);

        final int version;
        final CipherAlgorithm algorithm;
        final KeyDerivationFunction kdf;
        final Encryption.ProtectedStreamAlgorithm protectedStreamAlgorithm;

        private KdbxHeaderOpts(int version, Encryption.Cipher cipher, Encryption.KeyDerivationFunction kdf, Encryption.ProtectedStreamAlgorithm protectedStreamAlgorithm) {
            this.version = version;
            this.algorithm = cipher;
            this.kdf = kdf;
            this.protectedStreamAlgorithm = protectedStreamAlgorithm;
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        @Override
        public CipherAlgorithm getCipherAlgorithm() {
            return this.algorithm;
        }

        @Override
        public KeyDerivationFunction getKeyDerivationFunction() {
            return this.kdf;
        }

        @Override
        public Encryption.ProtectedStreamAlgorithm getProtectedStreamAlgorithm() {
            return this.protectedStreamAlgorithm;
        }
    }

    static interface KdbxHeaderOptions {
        public int getVersion();

        public CipherAlgorithm getCipherAlgorithm();

        public KeyDerivationFunction getKeyDerivationFunction();

        public Encryption.ProtectedStreamAlgorithm getProtectedStreamAlgorithm();
    }

    public static enum CompressionFlags {
        NONE,
        GZIP;

    }
}

