/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.simple.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.linguafranca.pwdb.kdbx.simple.SimpleEntry;
import org.linguafranca.pwdb.kdbx.simple.converter.KeePassBooleanConverter;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Text;
import org.simpleframework.xml.convert.Convert;
import org.simpleframework.xml.util.Entry;

public abstract class EntryClasses {
    public static StringProperty getStringProperty(String name, List<StringProperty> string) {
        for (StringProperty property : string) {
            if (!property.key.equals(name)) continue;
            return property;
        }
        return null;
    }

    public static String getStringContent(StringProperty property) {
        return property == null || property.value == null ? null : property.value.text;
    }

    public static BinaryProperty getBinaryProp(String name, List<BinaryProperty> binary) {
        for (BinaryProperty property : binary) {
            if (!property.key.equals(name)) continue;
            return property;
        }
        return null;
    }

    public static String getBinaryContent(BinaryProperty property) {
        return property == null || property.value == null ? null : property.value.ref;
    }

    public static class History {
        @ElementList(entry="SimpleEntry", inline=true)
        private List<SimpleEntry> list = new ArrayList<SimpleEntry>();

        public List<SimpleEntry> getHistory() {
            return this.list;
        }
    }

    @Root(name="Binary")
    public static class BinaryProperty
    implements Entry {
        @Element(name="Key")
        String key;
        @Element(name="Value")
        Value value;

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(Value value) {
            this.value = value;
        }

        @Root(name="Value")
        public static class Value {
            @Attribute(name="Ref")
            String ref;

            public void setRef(String ref) {
                this.ref = ref;
            }
        }
    }

    @Root(name="String")
    public static class StringProperty
    implements Entry {
        @Element(name="Key")
        String key;
        @Element(name="Value")
        Value value;

        public StringProperty() {
            this("", new Value());
        }

        public StringProperty(String key, Value value) {
            this.key = key;
            this.value = value;
        }

        public String getName() {
            return this.key;
        }

        public String getKey() {
            return this.key;
        }

        public Value getValue() {
            return this.value;
        }

        @Root(name="Value")
        public static class Value {
            @Attribute(name="ProtectInMemory", required=false)
            @Convert(value=KeePassBooleanConverter.class)
            protected Boolean protectInMemory;
            @Attribute(name="Protected", required=false)
            Boolean _protected;
            @Attribute(name="kpj2-ProtectOnOutput", required=false)
            @Convert(value=KeePassBooleanConverter.class)
            Boolean protectOnOutput;
            @Text
            String text;

            public Value() {
                this("");
            }

            public Value(String text) {
                this.text = text;
                this._protected = false;
            }

            public Value(String text, Boolean _protected) {
                this._protected = _protected;
                this.text = text;
            }

            public String getText() {
                return this.text;
            }

            public void setText(String text) {
                this.text = text;
            }

            public void setProtectOnOutput(boolean aProtected) {
                this.protectOnOutput = aProtected;
            }

            public boolean getProtectOnOutput() {
                return Objects.nonNull(this.protectOnOutput) && this.protectOnOutput != false;
            }

            public Boolean getProtected() {
                return this._protected;
            }

            public void setProtected(Boolean _protected) {
                this._protected = _protected;
            }
        }
    }

    @Root(name="AutoType")
    public static class AutoType {
        @Element(name="Enabled", type=Boolean.class)
        @Convert(value=KeePassBooleanConverter.class)
        protected Boolean enabled;
        @Element(name="DataTransferObfuscation")
        protected int dataTransferObfuscation;
        @Element(name="DefaultSequence", required=false)
        protected String defaultSequence;
        @Element(name="Association", required=false)
        protected Association association;

        public static class Association {
            @Element(name="Window")
            protected String window;
            @Element(name="KeystrokeSequence")
            protected String keystrokeSequence;
            protected List<Object> windowAndKeystrokeSequence;
        }
    }
}

