/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.simple.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.linguafranca.pwdb.kdbx.simple.SimpleGroup;
import org.linguafranca.pwdb.kdbx.simple.converter.Base64ByteArrayConverter;
import org.linguafranca.pwdb.kdbx.simple.converter.KeePassBooleanConverter;
import org.linguafranca.pwdb.kdbx.simple.converter.TimeConverter;
import org.linguafranca.pwdb.kdbx.simple.converter.UuidConverter;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Text;
import org.simpleframework.xml.convert.Convert;
import org.simpleframework.xml.util.Entry;

@org.simpleframework.xml.Root(name="KeePassFile")
public class KeePassFile {
    @Element(name="Meta")
    public Meta meta;
    @Element(name="Root")
    public Root root;

    public List<Binary> getBinaries() {
        return this.meta.binaries;
    }

    public void createBinaries() {
        this.meta.binaries = new ArrayList<Binary>();
    }

    @org.simpleframework.xml.Root(name="DeletedObject")
    public static class DeletedObject {
        @Element(name="UUID", type=UUID.class)
        @Convert(value=UuidConverter.class)
        protected UUID uuid;
        @Element(name="DeletionTime", type=Date.class)
        @Convert(value=TimeConverter.class)
        protected Date deletionTime;
    }

    public static class CustomData {
        protected List<Object> any;
    }

    public static class ByteArray {
        private byte[] content;

        public ByteArray(byte[] content) {
            this.content = content;
        }

        public byte[] getContent() {
            return this.content;
        }

        public void setContent(byte[] content) {
            this.content = content;
        }
    }

    @org.simpleframework.xml.Root(name="Icon")
    public static class Icon
    implements Entry {
        @Element(name="UUID", type=UUID.class)
        @Convert(value=UuidConverter.class)
        protected UUID uuid;
        @Element(name="Name")
        protected String name;
        @Element(name="LastModificationTime", type=Date.class)
        @Convert(value=TimeConverter.class)
        protected Date lastModificationTime;
        @Element(name="Data")
        @Convert(value=Base64ByteArrayConverter.class)
        protected ByteArray data;

        public String getName() {
            return this.uuid.toString();
        }
    }

    @org.simpleframework.xml.Root(name="Binary")
    public static class Binary
    implements Entry {
        @Text
        protected String value;
        @Attribute(name="ID")
        protected Integer id;
        @Attribute(name="Compressed")
        @Convert(value=KeePassBooleanConverter.class)
        protected Boolean compressed;

        public String getName() {
            return String.valueOf(this.id);
        }

        public String getValue() {
            return this.value;
        }

        public Boolean getCompressed() {
            return this.compressed;
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer Id) {
            this.id = Id;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setCompressed(boolean compressed) {
            this.compressed = compressed;
        }
    }

    public static class Binaries {
    }

    public static class MemoryProtection {
        @Element(name="ProtectTitle", type=Boolean.class)
        @Convert(value=KeePassBooleanConverter.class)
        protected Boolean protectTitle;
        @Element(name="ProtectUserName", type=Boolean.class)
        @Convert(value=KeePassBooleanConverter.class)
        protected Boolean protectUserName;
        @Element(name="ProtectPassword", type=Boolean.class)
        @Convert(value=KeePassBooleanConverter.class)
        protected Boolean protectPassword;
        @Element(name="ProtectURL", type=Boolean.class)
        @Convert(value=KeePassBooleanConverter.class)
        protected Boolean protectURL;
        @Element(name="ProtectNotes", type=Boolean.class)
        @Convert(value=KeePassBooleanConverter.class)
        protected Boolean protectNotes;

        public Boolean shouldProtect(String name) {
            switch (name) {
                case "Title": {
                    return this.protectTitle;
                }
                case "UserName": {
                    return this.protectUserName;
                }
                case "Password": {
                    return this.protectPassword;
                }
                case "URL": {
                    return this.protectURL;
                }
                case "Notes": {
                    return this.protectNotes;
                }
            }
            return false;
        }
    }

    public static class Meta {
        @Element(name="Generator")
        public String generator;
        @Element(name="HeaderHash", required=false)
        @Convert(value=Base64ByteArrayConverter.class)
        public ByteArray headerHash;
        @Element(name="DatabaseName")
        public String databaseName;
        @Element(name="DatabaseNameChanged", type=Date.class)
        @Convert(value=TimeConverter.class)
        public Date databaseNameChanged;
        @Element(name="DatabaseDescription")
        public String databaseDescription;
        @Element(name="DatabaseDescriptionChanged", type=Date.class)
        @Convert(value=TimeConverter.class)
        public Date databaseDescriptionChanged;
        @Element(name="DefaultUserName")
        protected String defaultUserName;
        @Element(name="DefaultUserNameChanged", type=Date.class)
        @Convert(value=TimeConverter.class)
        protected Date defaultUserNameChanged;
        @Element(name="MaintenanceHistoryDays")
        protected int maintenanceHistoryDays;
        @Element(name="Color")
        protected String color;
        @Element(name="MasterKeyChanged", type=Date.class)
        @Convert(value=TimeConverter.class)
        protected Date masterKeyChanged;
        @Element(name="MasterKeyChangeRec")
        protected int masterKeyChangeRec;
        @Element(name="MasterKeyChangeForce")
        protected int masterKeyChangeForce;
        @Element(name="MemoryProtection")
        public MemoryProtection memoryProtection;
        @ElementList(name="CustomIcons", required=false)
        protected ArrayList<Icon> customIcons;
        @Element(name="RecycleBinEnabled", type=Boolean.class)
        @Convert(value=KeePassBooleanConverter.class)
        public Boolean recycleBinEnabled;
        @Element(name="RecycleBinUUID", type=UUID.class)
        @Convert(value=UuidConverter.class)
        public UUID recycleBinUUID;
        @Element(name="RecycleBinChanged", type=Date.class)
        @Convert(value=TimeConverter.class)
        public Date recycleBinChanged;
        @Element(name="EntryTemplatesGroup", type=UUID.class)
        @Convert(value=UuidConverter.class)
        protected UUID entryTemplatesGroup;
        @Element(name="EntryTemplatesGroupChanged", type=Date.class)
        @Convert(value=TimeConverter.class)
        protected Date entryTemplatesGroupChanged;
        @Element(name="LastSelectedGroup", type=UUID.class)
        @Convert(value=UuidConverter.class)
        protected UUID lastSelectedGroup;
        @Element(name="LastTopVisibleGroup", type=UUID.class)
        @Convert(value=UuidConverter.class)
        protected UUID lastTopVisibleGroup;
        @Element(name="HistoryMaxItems")
        protected int historyMaxItems;
        @Element(name="HistoryMaxSize")
        protected int historyMaxSize;
        @ElementList(name="Binaries", required=false)
        protected List<Binary> binaries;
        @Element(name="CustomData", required=false)
        protected CustomData customData;
        @Element(name="SettingsChanged", required=false, type=Date.class)
        @Convert(value=TimeConverter.class)
        protected Date settingsChanged;
    }

    public static class Root {
        @Element(name="Group")
        public SimpleGroup group;
        @ElementList(name="DeletedObjects", required=false)
        protected ArrayList<DeletedObject> deletedObjects;

        public SimpleGroup getGroup() {
            return this.group;
        }
    }
}

