/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.linguafranca.pwdb.Credentials;
import org.linguafranca.pwdb.SerializableDatabase;
import org.linguafranca.pwdb.StreamConfiguration;
import org.linguafranca.pwdb.security.StreamEncryptor;

public interface StreamFormat<C extends StreamConfiguration> {
    public void load(SerializableDatabase var1, Credentials var2, InputStream var3) throws IOException;

    public void save(SerializableDatabase var1, Credentials var2, OutputStream var3) throws IOException;

    public C getStreamConfiguration();

    public void setStreamConfiguration(C var1);

    public static class None
    implements StreamFormat<StreamConfiguration.None> {
        @Override
        public void load(SerializableDatabase serializableDatabase, Credentials credentials, InputStream inputStream) throws IOException {
            serializableDatabase.setEncryption(new StreamEncryptor.None());
            serializableDatabase.load(inputStream);
            inputStream.close();
        }

        @Override
        public void save(SerializableDatabase serializableDatabase, Credentials credentials, OutputStream outputStream) throws IOException {
            serializableDatabase.setEncryption(new StreamEncryptor.None());
            serializableDatabase.save(outputStream);
            outputStream.flush();
            outputStream.close();
        }

        @Override
        public StreamConfiguration.None getStreamConfiguration() {
            return new StreamConfiguration.None();
        }

        @Override
        public void setStreamConfiguration(StreamConfiguration.None configuration) {
        }
    }
}

