/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;
import org.linguafranca.pwdb.Credentials;
import org.linguafranca.pwdb.Entry;
import org.linguafranca.pwdb.Group;
import org.linguafranca.pwdb.Icon;
import org.linguafranca.pwdb.PropertyValue;
import org.linguafranca.pwdb.StreamConfiguration;
import org.linguafranca.pwdb.StreamFormat;
import org.linguafranca.pwdb.Visitor;

public interface Database<D extends Database<D, G, E, I>, G extends Group<D, G, E, I>, E extends Entry<D, G, E, I>, I extends Icon> {
    public G getRootGroup();

    public G newGroup();

    public G newGroup(String var1);

    public G newGroup(Group<?, ?, ?, ?> var1);

    public E newEntry();

    public E newEntry(String var1);

    public E newEntry(Entry<?, ?, ?, ?> var1);

    public I newIcon();

    public I newIcon(Integer var1);

    @Nullable
    public E findEntry(UUID var1);

    public boolean deleteEntry(UUID var1);

    @Nullable
    public G findGroup(UUID var1);

    public boolean deleteGroup(UUID var1);

    public boolean isRecycleBinEnabled();

    public void enableRecycleBin(boolean var1);

    @Nullable
    public G getRecycleBin();

    public void emptyRecycleBin();

    public void visit(Visitor<D, G, E, I> var1);

    public void visit(G var1, Visitor<D, G, E, I> var2);

    public List<? extends E> findEntries(Entry.Matcher var1);

    public List<? extends E> findEntries(String var1);

    public String getName();

    public void setName(String var1);

    public String getDescription();

    public void setDescription(String var1);

    public boolean isDirty();

    public void save(Credentials var1, OutputStream var2) throws IOException;

    public <C extends StreamConfiguration> void save(StreamFormat<C> var1, Credentials var2, OutputStream var3) throws IOException;

    public <C extends StreamConfiguration> StreamFormat<C> getStreamFormat();

    public boolean shouldProtect(String var1);

    public void setShouldProtect(String var1, boolean var2);

    public List<String> listShouldProtect();

    public PropertyValue.Strategy getPropertyValueStrategy();

    public void setPropertyValueStrategy(PropertyValue.Strategy var1);

    public boolean supportsNonStandardPropertyNames();

    public boolean supportsBinaryProperties();

    public boolean supportsRecycleBin();

    public boolean supportsPropertyValueStrategy();
}

