/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.protect;

import java.util.Collections;
import java.util.List;
import org.linguafranca.pwdb.Database;
import org.linguafranca.pwdb.Entry;
import org.linguafranca.pwdb.Group;
import org.linguafranca.pwdb.Icon;
import org.linguafranca.pwdb.PropertyValue;
import org.linguafranca.pwdb.base.AbstractDatabase;

public abstract class ProtectedDatabase<D extends Database<D, G, E, I>, G extends Group<D, G, E, I>, E extends Entry<D, G, E, I>, I extends Icon>
extends AbstractDatabase<D, G, E, I> {
    private PropertyValue.Strategy valueStrategy = new PropertyValue.Strategy.Default();

    @Override
    public boolean shouldProtect(String propertyName) {
        return this.valueStrategy.getProtectedProperties().contains(propertyName);
    }

    @Override
    public void setShouldProtect(String propertyName, boolean protect) {
        if (protect) {
            this.valueStrategy.getProtectedProperties().add(propertyName);
        } else {
            this.valueStrategy.getProtectedProperties().remove(propertyName);
        }
    }

    @Override
    public List<String> listShouldProtect() {
        return Collections.unmodifiableList(this.valueStrategy.getProtectedProperties());
    }

    @Override
    public PropertyValue.Strategy getPropertyValueStrategy() {
        return this.valueStrategy;
    }

    @Override
    public void setPropertyValueStrategy(PropertyValue.Strategy strategy) {
        this.valueStrategy = strategy;
    }

    @Override
    public boolean supportsPropertyValueStrategy() {
        return true;
    }
}

