/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.security;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.linguafranca.pwdb.security.Aes;
import org.linguafranca.pwdb.security.Argon2;
import org.linguafranca.pwdb.security.ChaCha;
import org.linguafranca.pwdb.security.CipherAlgorithm;
import org.linguafranca.pwdb.security.StreamEncryptor;
import org.linguafranca.pwdb.security.VariantDictionary;

public class Encryption {
    public static MessageDigest getSha256MessageDigestInstance() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA-256 is not supported");
        }
    }

    public static MessageDigest getSha512MessageDigestInstance() {
        try {
            return MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA-512 is not supported");
        }
    }

    public static Mac getHMacSha256Instance(byte[] key) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key, "HmacSHA256"));
            return mac;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("HmacSHA256 is not supported", e);
        }
    }

    public static byte[] transformHmacKey(byte[] digest, byte[] transform) {
        MessageDigest md = Encryption.getSha512MessageDigestInstance();
        md.update(transform);
        return md.digest(digest);
    }

    public static enum ProtectedStreamAlgorithm {
        NONE(0),
        ARC_FOUR(1),
        SALSA_20(2),
        CHA_CHA_20(3);

        private final int value;

        private ProtectedStreamAlgorithm(int value) {
            this.value = value;
        }

        public static ProtectedStreamAlgorithm getAlgorithm(int innerRandomStreamId) {
            for (ProtectedStreamAlgorithm pse : ProtectedStreamAlgorithm.values()) {
                if (pse.value != innerRandomStreamId) continue;
                return pse;
            }
            throw new IllegalArgumentException("Inner Random Stream Id " + innerRandomStreamId + "is not known");
        }

        public static StreamEncryptor getStreamEncryptor(ProtectedStreamAlgorithm psa, byte[] key) {
            switch (psa) {
                case NONE: {
                    throw new IllegalStateException("Inner stream encoding of NONE");
                }
                case ARC_FOUR: {
                    throw new UnsupportedOperationException("Arc Four inner stream not supported");
                }
                case SALSA_20: {
                    return new StreamEncryptor.Salsa20(key);
                }
                case CHA_CHA_20: {
                    return new StreamEncryptor.ChaCha20(key);
                }
            }
            throw new IllegalStateException("Inner stream encoding unsupported");
        }
    }

    public static enum Cipher implements CipherAlgorithm
    {
        CHA_CHA_20(ChaCha.getInstance()),
        AES(Aes.getInstance());

        private final CipherAlgorithm ef;

        public static CipherAlgorithm getCipherAlgorithm(UUID cipherUuid) {
            for (Cipher ca : Cipher.values()) {
                if (!ca.getCipherUuid().equals(cipherUuid)) continue;
                return ca;
            }
            throw new IllegalArgumentException("Unknown Cipher UUID");
        }

        private Cipher(CipherAlgorithm ef) {
            this.ef = ef;
        }

        @Override
        public UUID getCipherUuid() {
            return this.ef.getCipherUuid();
        }

        @Override
        public String getName() {
            return this.ef.getName();
        }

        @Override
        public InputStream getDecryptedInputStream(InputStream encryptedInputStream, byte[] key, byte[] iv) {
            return this.ef.getDecryptedInputStream(encryptedInputStream, key, iv);
        }

        @Override
        public OutputStream getEncryptedOutputStream(OutputStream decryptedOutputStream, byte[] key, byte[] iv) {
            return this.ef.getEncryptedOutputStream(decryptedOutputStream, key, iv);
        }
    }

    public static enum KeyDerivationFunction implements org.linguafranca.pwdb.security.KeyDerivationFunction
    {
        AES(Aes.getInstance()),
        ARGON2(Argon2.getInstance());

        private final org.linguafranca.pwdb.security.KeyDerivationFunction kdf;

        private KeyDerivationFunction(org.linguafranca.pwdb.security.KeyDerivationFunction kdf) {
            this.kdf = kdf;
        }

        public static org.linguafranca.pwdb.security.KeyDerivationFunction getKdf(UUID kdfUuid) {
            for (KeyDerivationFunction kdf : KeyDerivationFunction.values()) {
                if (!kdf.getKdfUuid().equals(kdfUuid)) continue;
                return kdf;
            }
            throw new IllegalArgumentException("Unknown Cipher UUID");
        }

        @Override
        public UUID getKdfUuid() {
            return this.kdf.getKdfUuid();
        }

        @Override
        public byte[] getTransformedKey(byte[] key, VariantDictionary transformParams) {
            return this.kdf.getTransformedKey(key, transformParams);
        }

        @Override
        public VariantDictionary createKdfParameters() {
            return this.kdf.createKdfParameters();
        }

        @Override
        public String getName() {
            return this.kdf.getName();
        }
    }
}

