/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.security;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariantDictionary {
    private final short version;
    private final Map<String, Entry> entries = new HashMap<String, Entry>();
    private static final String knn = "VariantDictionary key must not be null";
    private static final String vnn = "VariantDictionary.Entry value must not be null";

    public VariantDictionary(short version) {
        if (version != 1) {
            throw new IllegalArgumentException("Variant Dictionary version must be 1");
        }
        this.version = version;
    }

    public VariantDictionary copy() {
        VariantDictionary vd = new VariantDictionary(this.version);
        vd.entries.putAll(this.entries);
        return vd;
    }

    public Map<String, Entry> getEntries() {
        return this.entries;
    }

    public short getVersion() {
        return this.version;
    }

    @Nullable
    public Entry get(@NotNull String key) {
        return this.entries.get(key);
    }

    @NotNull
    public Entry mustGet(@NotNull String key) {
        Entry entry = this.entries.get(key);
        if (entry == null) {
            throw new IllegalArgumentException("There is no entry with key " + key);
        }
        return entry;
    }

    public void put(@NotNull String key, EntryType type, byte @NotNull [] value) {
        this.entries.put((String)Preconditions.checkNotNull((Object)key), new Entry(type, (byte[])Preconditions.checkNotNull((Object)value)));
    }

    public void putUuid(@NotNull String key, UUID uuid) {
        byte[] buf = new byte[16];
        ByteBuffer bb = ByteBuffer.wrap(buf);
        bb.putLong(0, uuid.getMostSignificantBits());
        bb.putLong(8, uuid.getLeastSignificantBits());
        this.entries.put((String)Preconditions.checkNotNull((Object)key, (Object)knn), new Entry(EntryType.ARRAY, buf));
    }

    public void putByteArray(@NotNull String key, byte @NotNull [] value) {
        this.entries.put((String)Preconditions.checkNotNull((Object)key, (Object)knn), new Entry(EntryType.ARRAY, value));
    }

    public void putLong(@NotNull String key, long value) {
        byte[] buf = new byte[8];
        ByteBuffer bb = ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN);
        bb.putLong(value);
        this.entries.put((String)Preconditions.checkNotNull((Object)key, (Object)knn), new Entry(EntryType.INT64, buf));
    }

    public void putULong(@NotNull String key, long value) {
        byte[] buf = new byte[8];
        ByteBuffer bb = ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN);
        bb.putLong(value);
        this.entries.put((String)Preconditions.checkNotNull((Object)key, (Object)knn), new Entry(EntryType.UINT64, buf));
    }

    public void putInt(@NotNull String key, int value) {
        byte[] buf = new byte[4];
        ByteBuffer bb = ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN);
        bb.putInt(value);
        this.entries.put((String)Preconditions.checkNotNull((Object)key, (Object)knn), new Entry(EntryType.INT32, buf));
    }

    public void putUInt(@NotNull String key, int value) {
        byte[] buf = new byte[4];
        ByteBuffer bb = ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN);
        bb.putInt(value);
        this.entries.put((String)Preconditions.checkNotNull((Object)key, (Object)knn), new Entry(EntryType.UINT32, buf));
    }

    @Immutable
    public static class Entry {
        private final byte type;
        private final byte @NotNull [] value;
        private final ByteOrder byteOrder;

        public Entry(EntryType entryType, byte @NotNull [] value) {
            this(entryType, value, ByteOrder.LITTLE_ENDIAN);
        }

        public Entry(EntryType entryType, byte @NotNull [] value, ByteOrder byteOrder) {
            this.type = entryType.value;
            this.value = (byte[])Preconditions.checkNotNull((Object)value, (Object)VariantDictionary.vnn);
            this.byteOrder = byteOrder;
        }

        public byte getType() {
            return this.type;
        }

        public UUID asUuid() {
            if (this.value.length == 16) {
                ByteBuffer b = ByteBuffer.wrap(this.value);
                return new UUID(b.getLong(), b.getLong(8));
            }
            throw new IllegalStateException("Cannot convert value to UUID");
        }

        public long asLong() {
            if (this.value.length != 8) {
                throw new IllegalStateException("Cannot convert value to long");
            }
            return ByteBuffer.wrap(this.value).order(this.byteOrder).getLong();
        }

        public int asInteger() {
            if (this.value.length != 4) {
                throw new IllegalStateException("Cannot convert value to int");
            }
            return ByteBuffer.wrap(this.value).order(this.byteOrder).getInt();
        }

        public byte @NotNull [] asByteArray() {
            return this.value;
        }
    }

    public static enum EntryType {
        UINT32(4),
        UINT64(5),
        BOOL(8),
        INT32(12),
        INT64(13),
        STRING(24),
        ARRAY(66);

        private final byte value;

        private EntryType(int b) {
            this.value = (byte)b;
        }

        public static EntryType get(byte type) {
            for (EntryType et : EntryType.values()) {
                if (et.value != type) continue;
                return et;
            }
            throw new IllegalArgumentException("Unknown Variant Dictionary Type " + String.format("%x", type));
        }
    }
}

