/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class MetaAnnotation<META extends Annotation> {
    private final Class<META> metaAnnotationClass;
    private final boolean repeatable;

    private MetaAnnotation(Class<META> metaAnnotationClass) {
        this.metaAnnotationClass = metaAnnotationClass;
        this.repeatable = metaAnnotationClass.isAnnotationPresent(Repeatable.class);
    }

    public static <META extends Annotation> MetaAnnotation<META> of(Class<META> metaAnnotationClass) {
        Target target = metaAnnotationClass.getAnnotation(Target.class);
        if (target == null) {
            throw new IllegalArgumentException(metaAnnotationClass.getSimpleName() + " has no @" + Target.class.getSimpleName() + " annotation");
        }
        if (Arrays.stream(target.value()).noneMatch(t -> t == ElementType.ANNOTATION_TYPE || t == ElementType.TYPE)) {
            throw new IllegalArgumentException(metaAnnotationClass.getSimpleName() + " is no meta-annotation. @" + Target.class.getSimpleName() + " is " + Arrays.toString((Object[])target.value()) + " but should be " + ElementType.ANNOTATION_TYPE);
        }
        return new MetaAnnotation<META>(metaAnnotationClass);
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public boolean isPresentOnAnyAnnotationOn(AnnotatedElement annotatedElement) {
        return Arrays.stream(annotatedElement.getAnnotations()).anyMatch(this::isPresentOn);
    }

    public boolean isPresentOn(@CheckForNull Annotation annotation) {
        if (annotation != null) {
            return this.repeatable ? annotation.annotationType().getAnnotationsByType(this.metaAnnotationClass).length > 0 : annotation.annotationType().isAnnotationPresent(this.metaAnnotationClass);
        }
        return false;
    }

    public Optional<META> findOn(Annotation annotation) {
        return this.repeatable ? this.findAllOn(annotation).reduce((a1, a2) -> {
            throw new IllegalArgumentException(annotation.annotationType() + " has multiple @" + this.metaAnnotationClass.getSimpleName() + " annotations. Please use " + MetaAnnotation.class.getSimpleName() + "#findAllOn(Annotation) for repeatable annotations.");
        }) : Optional.ofNullable(annotation.annotationType().getAnnotation(this.metaAnnotationClass));
    }

    public Stream<META> findAllOn(Annotation annotation) {
        return Arrays.stream(annotation.annotationType().getAnnotationsByType(this.metaAnnotationClass));
    }

    public Stream<Annotation> findAnnotatedAnnotationsOn(AnnotatedElement annotatedElement) {
        return Arrays.stream(annotatedElement.getAnnotations()).filter(this::isPresentOn);
    }

    public <A extends Annotation> BinaryOperator<A> onlyOneOn(AnnotatedElement annotatedElement) {
        return (a1, a2) -> {
            throw new IllegalArgumentException(annotatedElement + " has multiple annotations with a @" + this.metaAnnotationClass.getSimpleName() + " annotation");
        };
    }

    public Supplier<? extends IllegalArgumentException> missingAnnotation(Annotation annotation, AnnotatedElement annotatedElement, String checkerMethod) {
        return () -> new IllegalArgumentException("@" + annotation.annotationType().getSimpleName() + " on " + annotatedElement + " is not annotated with @" + this.metaAnnotationClass.getSimpleName() + ". You can use " + checkerMethod + " to check this beforehand.");
    }
}

