/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.util;

import java.time.LocalDate;
import java.time.LocalDateTime;

public class TwoDigitYearUtil {
    static final TwoDigitYearUtil INSTANCE = new TwoDigitYearUtil();

    private TwoDigitYearUtil() {
    }

    public static LocalDate convert(LocalDate value) {
        return INSTANCE.convertInternal(value);
    }

    public static LocalDateTime convert(LocalDateTime value) {
        return INSTANCE.convertInternal(value);
    }

    LocalDate convertInternal(LocalDate value) {
        if (value.isAfter(LocalDate.of(-1, 1, 1)) && value.isBefore(LocalDate.of(100, 1, 1))) {
            LocalDate resultDate = value;
            LocalDate pivotLocalDate = LocalDate.now().withYear(this.getCurrentYear()).minusYears(80L);
            int pivotYear = pivotLocalDate.getYear() % 100;
            int pivotCentury = pivotLocalDate.minusYears(pivotYear).getYear();
            if (resultDate.getYear() < pivotYear) {
                resultDate = resultDate.plusYears(100L);
            }
            resultDate = resultDate.plusYears(pivotCentury);
            return resultDate;
        }
        return value;
    }

    LocalDateTime convertInternal(LocalDateTime value) {
        LocalDate convertedDate = this.convertInternal(value.toLocalDate());
        return LocalDateTime.of(convertedDate, value.toLocalTime());
    }

    int getCurrentYear() {
        return LocalDate.now().getYear();
    }
}

