/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.bigquery.datatype.core;

import liquibase.change.core.LoadDataChange;
import liquibase.database.Database;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.core.VarcharType;
import liquibase.ext.bigquery.database.BigQueryDatabase;

@DataTypeInfo(name="string", minParameters=0, maxParameters=0, priority=5, aliases={"varchar", "clob", "java.lang.String"})
public class StringDataTypeBigQuery
extends VarcharType {
    public boolean supports(Database database) {
        return database instanceof BigQueryDatabase;
    }

    public DatabaseDataType toDatabaseDataType(Database database) {
        if (database instanceof BigQueryDatabase) {
            DatabaseDataType type = new DatabaseDataType("STRING", this.getParameters());
            if (this.getParameters().length == 0) {
                type.setType("STRING");
            } else {
                String firstParameter = String.valueOf(this.getParameters()[0]);
                try {
                    int stringSize = Integer.parseInt(firstParameter);
                    if (stringSize == 65535) {
                        type.setType("STRING");
                    }
                }
                catch (NumberFormatException e) {
                    type.setType("STRING");
                }
            }
            return type;
        }
        return super.toDatabaseDataType(database);
    }

    public String objectToSql(Object value, Database database) {
        String ret = super.objectToSql(value, database);
        if (ret.contains("\n")) {
            return "''" + ret + "''";
        }
        return ret;
    }

    public LoadDataChange.LOAD_DATA_TYPE getLoadTypeName() {
        return LoadDataChange.LOAD_DATA_TYPE.STRING;
    }
}

