/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.bigquery.snapshot.jvm;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import liquibase.CatalogAndSchema;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.ext.bigquery.database.BigQueryDatabase;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotGenerator;
import liquibase.snapshot.jvm.PrimaryKeySnapshotGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawParameterizedSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Index;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;

public class BigQueryPrimaryKeySnapshotGenerator
extends PrimaryKeySnapshotGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (!(database instanceof BigQueryDatabase)) {
            return -1;
        }
        int priority = super.getPriority(objectType, database);
        if (priority > -1) {
            priority += 5;
        }
        return priority;
    }

    public Class<? extends SnapshotGenerator>[] replaces() {
        return new Class[]{PrimaryKeySnapshotGenerator.class};
    }

    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        Database database = snapshot.getDatabase();
        Schema schema = example.getSchema();
        String searchTableName = null;
        if (((PrimaryKey)example).getTable() != null) {
            searchTableName = ((PrimaryKey)example).getTable().getName();
            searchTableName = database.correctObjectName(searchTableName, Table.class);
        }
        PrimaryKey returnKey = null;
        String keyColumnUsageStatement = String.format("SELECT * FROM %s.INFORMATION_SCHEMA.KEY_COLUMN_USAGE WHERE CONSTRAINT_NAME = ?", schema.getSchema());
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        List maps = executor.queryForList((SqlStatement)new RawParameterizedSqlStatement(keyColumnUsageStatement, new Object[]{example.getName()}));
        for (Map map : maps) {
            String columnName = Objects.toString(map.get("COLUMN_NAME"), null);
            int position = ((Long)map.get("ORDINAL_POSITION")).intValue();
            if (returnKey == null) {
                returnKey = new PrimaryKey();
                String catalogName = (String)map.get("TABLE_CATALOG");
                String schemaName = (String)map.get("TABLE_SCHEMA");
                CatalogAndSchema tableSchema = new CatalogAndSchema(catalogName, schemaName);
                returnKey.setTable((Table)new Table().setName(Objects.toString(map.get("TABLE_NAME"), null)).setSchema(new Schema(tableSchema.getCatalogName(), tableSchema.getSchemaName())));
                returnKey.setName(Objects.toString(map.get("CONSTRAINT_NAME"), null));
            }
            returnKey.addColumn(position - 1, new Column(columnName).setRelation((Relation)((PrimaryKey)example).getTable()));
        }
        if (returnKey != null) {
            Index exampleIndex = new Index().setRelation((Relation)returnKey.getTable());
            exampleIndex.setColumns(returnKey.getColumns());
            returnKey.setBackingIndex(exampleIndex);
        }
        return returnKey;
    }

    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException {
        if (!snapshot.getSnapshotControl().shouldInclude(PrimaryKey.class)) {
            return;
        }
        if (foundObject instanceof Table) {
            Table table = (Table)foundObject;
            Database database = snapshot.getDatabase();
            Schema schema = table.getSchema();
            Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
            String tableConstraintsStatement = String.format("SELECT * FROM %s.INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_TYPE = 'PRIMARY KEY' AND table_name = ?", schema.getSchema());
            List maps = executor.queryForList((SqlStatement)new RawParameterizedSqlStatement(tableConstraintsStatement, new Object[]{table.getName()}));
            for (Map map : maps) {
                if (!map.containsKey("CONSTRAINT_NAME")) continue;
                String constraintName = Objects.toString(map.get("CONSTRAINT_NAME"), null);
                PrimaryKey primaryKey = new PrimaryKey().setName(constraintName);
                primaryKey.setTable((Table)foundObject);
                if (database.isSystemObject((DatabaseObject)primaryKey)) continue;
                table.setPrimaryKey(primaryKey.setTable(table));
            }
        }
    }
}

