/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.bigquery.sqlgenerator;

import liquibase.Scope;
import liquibase.database.Database;
import liquibase.datatype.DataTypeFactory;
import liquibase.datatype.DatabaseDataType;
import liquibase.ext.bigquery.database.BigQueryDatabase;
import liquibase.sqlgenerator.core.AddColumnGenerator;
import liquibase.statement.AutoIncrementConstraint;
import liquibase.statement.core.AddColumnStatement;

public class BigQueryAddColumnGenerator
extends AddColumnGenerator {
    protected String generateSingleColumnSQL(AddColumnStatement statement, Database database) {
        DatabaseDataType columnType = null;
        if (statement.getColumnType() != null) {
            columnType = DataTypeFactory.getInstance().fromDescription(statement.getColumnType() + (statement.isAutoIncrement() ? "{autoIncrement:true}" : ""), database).toDatabaseDataType(database);
        }
        String alterTable = " ADD COLUMN " + database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getColumnName());
        if (columnType != null) {
            alterTable = alterTable + " " + columnType;
        }
        if (statement.isAutoIncrement() && database.supportsAutoIncrement()) {
            AutoIncrementConstraint autoIncrementConstraint = statement.getAutoIncrementConstraint();
            alterTable = alterTable + " " + database.getAutoIncrementClause(autoIncrementConstraint.getStartWith(), autoIncrementConstraint.getIncrementBy(), autoIncrementConstraint.getGenerationType(), autoIncrementConstraint.getDefaultOnNull());
        }
        if (statement.getDefaultValue() != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).fine("Default clauses are not supported during column creation by BigQuery");
        }
        if (!statement.isNullable()) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).fine("Not null constraints are not supported by BigQuery");
        }
        if (statement.isPrimaryKey()) {
            String baseSQL = this.generateSingleColumBaseSQL(statement, database);
            alterTable = alterTable + "; " + baseSQL + " ADD PRIMARY KEY (" + database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getColumnName()) + ") NOT ENFORCED";
        }
        if (statement.getAddBeforeColumn() != null && !statement.getAddBeforeColumn().isEmpty()) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).fine("Before clauses are not supported by BigQuery");
        }
        if (statement.getAddAfterColumn() != null && !statement.getAddAfterColumn().isEmpty()) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).fine("After clauses are not supported by BigQuery");
        }
        return alterTable;
    }

    public int getPriority() {
        return 510;
    }

    public boolean supports(AddColumnStatement statement, Database database) {
        return database instanceof BigQueryDatabase;
    }
}

