/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.bigquery.snapshot.jvm;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import liquibase.CatalogAndSchema;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.exception.DatabaseException;
import liquibase.ext.bigquery.database.BigQueryDatabase;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.jvm.SchemaSnapshotGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Schema;
import liquibase.util.JdbcUtil;

public class BigQueryDatasetSnapshotGenerator
extends SchemaSnapshotGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (!(database instanceof BigQueryDatabase)) {
            return -1;
        }
        int priority = super.getPriority(objectType, database);
        if (priority > -1 && database instanceof BigQueryDatabase) {
            priority += 5;
        }
        return priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getDatabaseSchemaNames(Database database) throws SQLException, DatabaseException {
        ArrayList<String> returnList = new ArrayList<String>();
        try (ResultSet schemas = null;){
            schemas = ((JdbcConnection)database.getConnection()).getMetaData().getSchemas(database.getDefaultCatalogName(), null);
            while (schemas.next()) {
                returnList.add(JdbcUtil.getValueForColumn((ResultSet)schemas, (String)"TABLE_SCHEM", (Database)database));
            }
        }
        return returnList.toArray(new String[returnList.size()]);
    }

    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        Database database = snapshot.getDatabase();
        Schema match = null;
        String catalogName = ((Schema)example).getCatalogName();
        String schemaName = example.getName();
        if (database.supports(Schema.class)) {
            if (catalogName == null) {
                catalogName = database.getDefaultCatalogName();
            }
            if (schemaName == null) {
                schemaName = database.getDefaultSchemaName();
            }
        } else if (database.supports(Catalog.class)) {
            if (catalogName == null && schemaName != null) {
                catalogName = schemaName;
                schemaName = null;
            }
        } else {
            catalogName = null;
            schemaName = null;
        }
        Schema example1 = new Schema(catalogName, schemaName);
        ObjectQuotingStrategy currentStrategy = database.getObjectQuotingStrategy();
        database.setObjectQuotingStrategy(ObjectQuotingStrategy.LEGACY);
        try {
            if (database.supports(Schema.class)) {
                String[] schemaNames;
                for (String tableSchema : schemaNames = this.getDatabaseSchemaNames(database)) {
                    CatalogAndSchema schemaFromJdbcInfo = this.toCatalogAndSchema(tableSchema, database);
                    Catalog catalog = new Catalog(schemaFromJdbcInfo.getCatalogName());
                    Schema schema = new Schema(catalog, tableSchema);
                    if (!DatabaseObjectComparatorFactory.getInstance().isSameObject((DatabaseObject)schema, (DatabaseObject)example1, snapshot.getSchemaComparisons(), database)) continue;
                    if (match != null) {
                        throw new InvalidExampleException("Found multiple catalog/schemas matching " + ((Schema)example).getCatalogName() + "." + example.getName());
                    }
                    match = schema;
                }
            } else if (example1.getCatalog().isDefault()) {
                match = new Schema(example1.getCatalog(), catalogName);
            } else {
                Catalog catalog = example1.getCatalog();
                String[] dbCatalogNames = this.getDatabaseCatalogNames(database);
                for (int i = 0; i < dbCatalogNames.length; ++i) {
                    String candidateCatalogName = dbCatalogNames[i];
                    if (!catalog.equals((Object)new Catalog(candidateCatalogName))) continue;
                    match = new Schema(catalog, catalogName);
                }
            }
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
        finally {
            database.setObjectQuotingStrategy(currentStrategy);
        }
        if (match != null && (match.getName() == null || match.getName().equalsIgnoreCase(database.getDefaultSchemaName()))) {
            match.setDefault(Boolean.valueOf(true));
        }
        return match;
    }
}

