/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.bigquery.snapshot.jvm;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import liquibase.CatalogAndSchema;
import liquibase.Scope;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.executor.ExecutorService;
import liquibase.ext.bigquery.database.BigQueryDatabase;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.SnapshotGenerator;
import liquibase.snapshot.jvm.ForeignKeySnapshotGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawParameterizedSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Column;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;

public class BigQueryForeignKeySnapshotGenerator
extends ForeignKeySnapshotGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (database instanceof BigQueryDatabase) {
            return super.getPriority(objectType, database) + 5;
        }
        return -1;
    }

    public Class<? extends SnapshotGenerator>[] replaces() {
        return new Class[]{ForeignKeySnapshotGenerator.class};
    }

    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException {
        Database database = snapshot.getDatabase();
        Table fkTable = ((ForeignKey)example).getForeignKeyTable();
        String searchTableName = database.correctObjectName(fkTable.getName(), Table.class);
        String fkFullName = searchTableName + "." + example.getName();
        String searchCatalog = ((AbstractJdbcDatabase)database).getJdbcCatalogName(fkTable.getSchema());
        String searchSchema = ((AbstractJdbcDatabase)database).getJdbcSchemaName(fkTable.getSchema());
        String systemSchema = database.getSystemSchema().toUpperCase();
        String query = "SELECT " + "TC.CONSTRAINT_NAME as CONSTRAINT_NAME, " + "KCU.TABLE_CATALOG as FOREIGN_KEY_TABLE_CATALOG, " + "KCU.TABLE_SCHEMA as FOREIGN_KEY_TABLE_SCHEMA, " + "KCU.TABLE_NAME as FOREIGN_KEY_TABLE, " + "KCU.COLUMN_NAME as FOREIGN_KEY_COLUMN, " + "CCU.TABLE_CATALOG as PRIMARY_KEY_TABLE_CATALOG, " + "CCU.TABLE_SCHEMA as PRIMARY_KEY_TABLE_SCHEMA, " + "CCU.TABLE_NAME as PRIMARY_KEY_TABLE, " + "CCU.COLUMN_NAME as PRIMARY_KEY_COLUMN " + String.format("FROM %1$s.%2$s.TABLE_CONSTRAINTS as TC JOIN %1$s.%2$s.CONSTRAINT_COLUMN_USAGE as CCU on TC.CONSTRAINT_NAME=CCU.CONSTRAINT_NAME JOIN %1$s.%2$s.KEY_COLUMN_USAGE as KCU on KCU.CONSTRAINT_NAME=TC.CONSTRAINT_NAME ", searchSchema, systemSchema) + "WHERE TC.TABLE_NAME=? AND TC.TABLE_SCHEMA=? AND TC.TABLE_CATALOG=? AND TC.CONSTRAINT_TYPE='FOREIGN KEY' AND TC.CONSTRAINT_NAME=?";
        List results = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database).queryForList((SqlStatement)new RawParameterizedSqlStatement(query, new Object[]{searchTableName, searchSchema, searchCatalog, fkFullName}));
        if (!results.isEmpty()) {
            ForeignKey foreignKey = null;
            for (Map resultMap : results) {
                Table foreignKeyTable = new Table().setName(Objects.toString(resultMap.get("FOREIGN_KEY_TABLE")));
                String foreignKeyName = Optional.ofNullable((String)resultMap.get("CONSTRAINT_NAME")).map(s -> s.replace(foreignKeyTable.getName() + ".", "")).orElse("undefined");
                foreignKeyTable.setSchema(new Schema(new Catalog(Objects.toString(resultMap.get("FOREIGN_KEY_TABLE_CATALOG"))), Objects.toString(resultMap.get("FOREIGN_KEY_TABLE_SCHEMA"))));
                Table primaryKeyTable = new Table().setName(Objects.toString(resultMap.get("PRIMARY_KEY_TABLE")));
                primaryKeyTable.setSchema(new Schema(new Catalog(Objects.toString(resultMap.get("PRIMARY_KEY_TABLE_CATALOG"))), Objects.toString(resultMap.get("PRIMARY_KEY_TABLE_SCHEMA"))));
                Column fkColumn = new Column(Objects.toString(resultMap.get("FOREIGN_KEY_COLUMN"))).setRelation((Relation)foreignKeyTable);
                Column pkColumn = new Column(Objects.toString(resultMap.get("PRIMARY_KEY_COLUMN"))).setRelation((Relation)primaryKeyTable);
                if (foreignKey != null) {
                    if (!foreignKey.getForeignKeyColumns().contains(fkColumn)) {
                        foreignKey.addForeignKeyColumn(fkColumn);
                    }
                    if (foreignKey.getPrimaryKeyColumns().contains(pkColumn)) continue;
                    foreignKey.addPrimaryKeyColumn(pkColumn);
                    continue;
                }
                foreignKey = new ForeignKey(foreignKeyName);
                foreignKey.setForeignKeyTable(foreignKeyTable);
                foreignKey.setPrimaryKeyTable(primaryKeyTable);
                foreignKey.addForeignKeyColumn(fkColumn);
                foreignKey.addPrimaryKeyColumn(pkColumn);
            }
            return foreignKey;
        }
        return null;
    }

    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException {
        if (!snapshot.getSnapshotControl().shouldInclude(ForeignKey.class)) {
            return;
        }
        if (foundObject instanceof Table) {
            Table table = (Table)foundObject;
            Database database = snapshot.getDatabase();
            Schema schema = table.getSchema();
            CatalogAndSchema catalogAndSchema = new CatalogAndSchema(schema.getCatalogName(), schema.getName()).customize(database);
            String jdbcSchemaName = database.correctObjectName(((AbstractJdbcDatabase)database).getJdbcSchemaName(catalogAndSchema), Schema.class);
            String query = String.format("SELECT CONSTRAINT_NAME FROM %s.%s.TABLE_CONSTRAINTS WHERE TABLE_NAME=? AND TABLE_SCHEMA=? AND TABLE_CATALOG=? AND CONSTRAINT_TYPE='FOREIGN KEY';", jdbcSchemaName, database.getSystemSchema().toUpperCase());
            List tableConstraints = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database).queryForList((SqlStatement)new RawParameterizedSqlStatement(query, new Object[]{table.getName(), schema.getName(), schema.getCatalogName()}));
            for (Map row : tableConstraints) {
                String foreignKeyName = Objects.toString(row.get("CONSTRAINT_NAME"));
                ForeignKey fk = new ForeignKey().setName(foreignKeyName.replace(table.getName() + ".", "")).setForeignKeyTable(table);
                table.getOutgoingForeignKeys().add(fk);
            }
        }
    }
}

