/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.bigquery.snapshot.jvm;

import java.util.List;
import java.util.Map;
import liquibase.CatalogAndSchema;
import liquibase.Scope;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.executor.ExecutorService;
import liquibase.ext.bigquery.database.BigQueryDatabase;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.jvm.ViewSnapshotGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.View;
import org.apache.commons.lang3.StringUtils;

public class BigQueryViewSnapshotGenerator
extends ViewSnapshotGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (!(database instanceof BigQueryDatabase)) {
            return -1;
        }
        int priority = super.getPriority(objectType, database);
        if (priority > -1 && database instanceof BigQueryDatabase) {
            priority += 5;
        }
        return priority;
    }

    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException {
        int length;
        if (((View)example).getDefinition() != null) {
            return example;
        }
        Database database = snapshot.getDatabase();
        Schema schema = example.getSchema();
        CatalogAndSchema catalogAndSchema = new CatalogAndSchema(schema.getCatalogName(), schema.getName()).customize(database);
        String jdbcSchemaName = database.correctObjectName(((AbstractJdbcDatabase)database).getJdbcSchemaName(catalogAndSchema), Schema.class);
        String query = String.format("SELECT view_definition FROM %s.%s.VIEWS WHERE table_name='%s' AND table_schema='%s' AND table_catalog='%s';", jdbcSchemaName, database.getSystemSchema().toUpperCase(), example.getName(), schema.getName(), schema.getCatalogName());
        List viewsMetadataRs = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database).queryForList((SqlStatement)new RawSqlStatement(query));
        if (viewsMetadataRs.isEmpty()) {
            return null;
        }
        Map row = (Map)viewsMetadataRs.get(0);
        String rawViewName = example.getName();
        String rawSchemaName = schema.getName();
        String rawCatalogName = schema.getCatalogName();
        String remarks = null;
        View view = new View().setName(this.cleanNameFromDatabase(rawViewName, database));
        view.setRemarks(remarks);
        CatalogAndSchema schemaFromJdbcInfo = ((AbstractJdbcDatabase)database).getSchemaFromJdbcInfo(rawCatalogName, rawSchemaName);
        view.setSchema(new Schema(schemaFromJdbcInfo.getCatalogName(), schemaFromJdbcInfo.getSchemaName()));
        String definition = (String)row.get("VIEW_DEFINITION");
        if (definition.startsWith("FULL_DEFINITION: ")) {
            definition = definition.replaceFirst("^FULL_DEFINITION: ", "");
            view.setContainsFullDefinition(true);
        }
        if ((length = definition.length()) > 0 && definition.charAt(length - 1) == '\u0000') {
            definition = definition.substring(0, length - 1);
        }
        if ((definition = StringUtils.trimToNull((String)definition)) == null) {
            definition = "[CANNOT READ VIEW DEFINITION]";
        }
        view.setDefinition(definition);
        return view;
    }
}

