/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cassandra.changelog;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.changelog.StandardChangeLogHistoryService;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.executor.ExecutorService;
import liquibase.ext.cassandra.database.CassandraDatabase;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;

public class CassandraChangeLogHistoryService
extends StandardChangeLogHistoryService {
    public int getPriority() {
        return 5;
    }

    public boolean supports(Database database) {
        return database instanceof CassandraDatabase;
    }

    public boolean hasDatabaseChangeLogTable() {
        boolean hasChangeLogTable;
        try {
            Statement statement = ((CassandraDatabase)this.getDatabase()).getStatement();
            statement.executeQuery("select ID from " + this.getChangeLogTableName());
            statement.close();
            hasChangeLogTable = true;
        }
        catch (SQLException e) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("No " + this.getChangeLogTableName() + " available in cassandra.");
            hasChangeLogTable = false;
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            hasChangeLogTable = false;
        }
        return hasChangeLogTable;
    }

    public int getNextSequenceValue() {
        int next = 0;
        try {
            Statement statement = ((CassandraDatabase)this.getDatabase()).getStatement();
            ResultSet rs = statement.executeQuery("SELECT ID as \"ID\", AUTHOR as \"AUTHOR\", FILENAME as \"FILENAME\", COMMENTS AS \"COMMENTS\", CONTEXTS AS \"CONTEXTS\", DATEEXECUTED AS \"DATEEXECUTED\", ORDEREXECUTED AS \"ORDEREXECUTED\", DEPLOYMENT_ID AS \"DEPLOYMENT_ID\", DESCRIPTION AS \"DESCRIPTION\", EXECTYPE AS \"EXECTYPE\", LABELS AS \"LABELS\", LIQUIBASE AS \"LIQUIBASE\", MD5SUM AS \"MD5SUM\", TAG AS \"TAG\" FROM " + this.getChangeLogTableName());
            while (rs.next()) {
                int order = rs.getInt("ORDEREXECUTED");
                next = Math.max(order, next);
            }
            statement.close();
        }
        catch (SQLException | DatabaseException e) {
            e.printStackTrace();
        }
        return next + 1;
    }

    public List<Map<String, ?>> queryDatabaseChangeLogTable(Database database) throws DatabaseException {
        RawSqlStatement select = new RawSqlStatement("SELECT ID as \"ID\", AUTHOR as \"AUTHOR\", FILENAME as \"FILENAME\", COMMENTS AS \"COMMENTS\", CONTEXTS AS \"CONTEXTS\", DATEEXECUTED AS \"DATEEXECUTED\", ORDEREXECUTED AS \"ORDEREXECUTED\", DEPLOYMENT_ID AS \"DEPLOYMENT_ID\", DESCRIPTION AS \"DESCRIPTION\", EXECTYPE AS \"EXECTYPE\", LABELS AS \"LABELS\", LIQUIBASE AS \"LIQUIBASE\", MD5SUM AS \"MD5SUM\", TAG AS \"TAG\" FROM " + this.getChangeLogTableName());
        List returnList = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database).queryForList((SqlStatement)select);
        returnList.sort(Comparator.comparing(o -> (Date)o.get("DATEEXECUTED")).thenComparingInt(o -> (Integer)o.get("ORDEREXECUTED")));
        return returnList;
    }

    private String getChangeLogTableName() {
        if (this.getDatabase().getLiquibaseCatalogName() != null) {
            return this.getDatabase().getLiquibaseCatalogName() + "." + this.getDatabase().getDatabaseChangeLogTableName();
        }
        return this.getDatabase().getDatabaseChangeLogTableName();
    }
}

