/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cassandra.database;

import com.ing.data.cassandra.jdbc.CassandraConnection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import liquibase.Scope;
import liquibase.configuration.ConfigurationDefinition;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.structure.core.Index;

public class CassandraDatabase
extends AbstractJdbcDatabase {
    public static final String PRODUCT_NAME = "Cassandra";
    public static final String SHORT_PRODUCT_NAME = "cassandra";
    public static final Integer DEFAULT_PORT = 9160;
    public static final String DEFAULT_DRIVER = "com.ing.data.cassandra.jdbc.CassandraDriver";
    private String keyspace;
    public static final ConfigurationDefinition<Boolean> AWS_KEYSPACES_COMPATIBILITY_MODE;

    public static boolean isAwsKeyspacesCompatibilityModeEnabled() {
        return (Boolean)AWS_KEYSPACES_COMPATIBILITY_MODE.getCurrentValue();
    }

    public String getShortName() {
        return SHORT_PRODUCT_NAME;
    }

    public int getPriority() {
        return 1;
    }

    protected String getDefaultDatabaseProductName() {
        return PRODUCT_NAME;
    }

    public Integer getDefaultPort() {
        return DEFAULT_PORT;
    }

    public int getDatabaseMinorVersion() throws DatabaseException {
        return 0;
    }

    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        String databaseProductName = conn.getDatabaseProductName();
        return PRODUCT_NAME.equalsIgnoreCase(databaseProductName);
    }

    public String getDefaultDriver(String url) {
        if (String.valueOf(url).startsWith("jdbc:cassandra:")) {
            return DEFAULT_DRIVER;
        }
        return null;
    }

    public boolean supportsTablespaces() {
        return false;
    }

    public boolean supportsRestrictForeignKeys() {
        return false;
    }

    public boolean supportsDropTableCascadeConstraints() {
        return false;
    }

    public boolean isAutoCommit() {
        return true;
    }

    public void setAutoCommit(boolean b) {
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public String getCurrentDateTimeFunction() {
        return String.valueOf(System.currentTimeMillis());
    }

    public String getKeyspace() {
        if (this.keyspace == null) {
            try {
                if (this.getConnection() instanceof JdbcConnection) {
                    this.keyspace = ((CassandraConnection)((JdbcConnection)this.getConnection()).getUnderlyingConnection()).getSchema();
                }
            }
            catch (Exception e) {
                Scope.getCurrentScope().getLog(CassandraDatabase.class).severe("Could not get keyspace from connection", (Throwable)e);
            }
        }
        return this.keyspace;
    }

    public boolean supportsSchemas() {
        return false;
    }

    public String getDefaultCatalogName() {
        return this.getKeyspace();
    }

    public Statement getStatement() throws DatabaseException {
        return ((JdbcConnection)super.getConnection()).createStatement();
    }

    public PreparedStatement prepareStatement(String query) throws DatabaseException {
        return ((JdbcConnection)super.getConnection()).prepareStatement(query);
    }

    public boolean jdbcCallsCatalogsSchemas() {
        return true;
    }

    public boolean supportsNotNullConstraintNames() {
        return false;
    }

    public boolean supportsPrimaryKeyNames() {
        return false;
    }

    public String escapeIndexName(String catalogName, String schemaName, String indexName) {
        return this.escapeObjectName(indexName, Index.class);
    }

    static {
        ConfigurationDefinition.Builder builder = new ConfigurationDefinition.Builder("liquibase.cassandra");
        AWS_KEYSPACES_COMPATIBILITY_MODE = builder.define("awsKeyspacesCompatibilityModeEnabled", Boolean.class).setDescription("Whether the compatibility mode for AWS Keyspaces must be enabled").addAliasKey("liquibase.cassandra.awsKeyspacesCompatibilityModeEnabled").setDefaultValue((Object)false).build();
        ((LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class)).registerDefinition(AWS_KEYSPACES_COMPATIBILITY_MODE);
    }
}

