/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cassandra.database;

import com.ing.data.cassandra.jdbc.CassandraDriver;
import java.net.URI;
import java.sql.Driver;
import java.util.Properties;
import liquibase.Scope;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;

public class CassandraDatabaseConnection
extends JdbcConnection {
    public int getPriority() {
        return 205;
    }

    public void open(String url, Driver driverObject, Properties driverProperties) throws DatabaseException {
        String jdbcUrl = url;
        if (driverObject instanceof CassandraDriver) {
            try {
                boolean complianceModePresent = false;
                String liquibaseComplianceModeParameter = "compliancemode=Liquibase";
                int protocolEndIdx = jdbcUrl.indexOf("://");
                String parseableUrl = "jdbc" + jdbcUrl.substring(protocolEndIdx);
                URI jdbcUri = URI.create(parseableUrl);
                String queryPart = jdbcUri.getQuery();
                if (queryPart != null) {
                    String[] queryParams;
                    for (String queryParam : queryParams = queryPart.split("&")) {
                        if (!"compliancemode=Liquibase".equals(queryParam)) continue;
                        complianceModePresent = true;
                        break;
                    }
                    if (!complianceModePresent) {
                        jdbcUrl = jdbcUrl + "&compliancemode=Liquibase";
                    }
                } else {
                    jdbcUrl = jdbcUrl + "?compliancemode=Liquibase";
                }
                Scope.getCurrentScope().getLog(CassandraDatabaseConnection.class).info("Connecting to Cassandra using: " + jdbcUrl);
            }
            catch (IllegalArgumentException e) {
                Scope.getCurrentScope().getLog(CassandraDatabaseConnection.class).warning("Unable to check compliance mode in JDBC URL, connecting with configured URL. The compliance mode might be incorrect.");
            }
        }
        this.openConnection(jdbcUrl, driverObject, driverProperties);
    }

    void openConnection(String url, Driver driverObject, Properties driverProperties) throws DatabaseException {
        super.open(url, driverObject, driverProperties);
    }
}

