/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cassandra.lockservice;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.ext.cassandra.database.CassandraDatabase;
import liquibase.lockservice.StandardLockService;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.LockDatabaseChangeLogStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.statement.core.UnlockDatabaseChangeLogStatement;
import liquibase.util.NetUtil;

public class LockServiceCassandra
extends StandardLockService {
    private boolean isDatabaseChangeLogLockTableInitialized;
    private ObjectQuotingStrategy quotingStrategy;

    public int getPriority() {
        return 5;
    }

    public boolean supports(Database database) {
        return database instanceof CassandraDatabase;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean acquireLock() throws LockException {
        if (this.hasChangeLogLock) {
            return true;
        }
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", this.database);
        try {
            this.database.rollback();
            super.init();
            if (this.isLocked(executor)) {
                boolean bl = false;
                return bl;
            }
            executor.comment("Lock Database");
            int rowsUpdated = executor.update((SqlStatement)new LockDatabaseChangeLogStatement());
            if (rowsUpdated == -1 && !this.isLockedByCurrentInstance(executor)) {
                boolean bl = false;
                return bl;
            }
            if (rowsUpdated > 1) {
                throw new LockException("Did not update change log lock correctly");
            }
            if (rowsUpdated == 0) {
                boolean bl = false;
                return bl;
            }
            this.database.commit();
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("successfully.acquired.change.log.lock");
            this.hasChangeLogLock = true;
            this.database.setCanCacheLiquibaseTableInfo(true);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new LockException((Throwable)e);
        }
        finally {
            try {
                this.database.rollback();
            }
            catch (DatabaseException databaseException) {}
        }
    }

    public void releaseLock() throws LockException {
        ObjectQuotingStrategy incomingQuotingStrategy = null;
        if (this.quotingStrategy != null) {
            incomingQuotingStrategy = this.database.getObjectQuotingStrategy();
            this.database.setObjectQuotingStrategy(this.quotingStrategy);
        }
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", this.database);
        try {
            if (this.isDatabaseChangeLogLockTableCreated()) {
                executor.comment("Release Database Lock");
                this.database.rollback();
                executor.update((SqlStatement)new UnlockDatabaseChangeLogStatement());
                this.database.commit();
            }
        }
        catch (Exception e) {
            throw new LockException((Throwable)e);
        }
        finally {
            try {
                this.hasChangeLogLock = false;
                this.database.setCanCacheLiquibaseTableInfo(false);
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Successfully released change log lock");
                this.database.rollback();
            }
            catch (DatabaseException databaseException) {}
            if (incomingQuotingStrategy != null) {
                this.database.setObjectQuotingStrategy(incomingQuotingStrategy);
            }
        }
    }

    public boolean isDatabaseChangeLogLockTableCreated() {
        boolean hasChangeLogLockTable;
        try {
            Statement statement = ((CassandraDatabase)this.database).getStatement();
            statement.executeQuery("SELECT ID FROM " + this.getChangeLogLockTableName());
            statement.close();
            hasChangeLogLockTable = true;
        }
        catch (SQLException e) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("No " + this.getChangeLogLockTableName() + " available in Cassandra.");
            hasChangeLogLockTable = false;
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            hasChangeLogLockTable = false;
        }
        return hasChangeLogLockTable;
    }

    public boolean isDatabaseChangeLogLockTableInitialized(boolean tableJustCreated, boolean forceRecheck) {
        if (!this.isDatabaseChangeLogLockTableInitialized || forceRecheck) {
            Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", this.database);
            try {
                this.isDatabaseChangeLogLockTableInitialized = this.executeCountQuery(executor, "SELECT COUNT(*) FROM " + this.getChangeLogLockTableName()) > 0;
            }
            catch (LiquibaseException e) {
                if (executor.updatesDatabase()) {
                    throw new UnexpectedLiquibaseException((Throwable)e);
                }
                this.isDatabaseChangeLogLockTableInitialized = !tableJustCreated;
            }
        }
        return this.isDatabaseChangeLogLockTableInitialized;
    }

    private boolean isLocked(Executor executor) throws DatabaseException {
        return this.isLockedByCurrentInstance(executor);
    }

    private boolean isLockedByCurrentInstance(Executor executor) throws DatabaseException {
        String lockedBy = NetUtil.getLocalHostName() + " (" + NetUtil.getLocalHostAddress() + ")";
        return this.executeCountQuery(executor, "SELECT COUNT(*) FROM " + this.getChangeLogLockTableName() + " WHERE LOCKED = TRUE AND LOCKEDBY = '" + lockedBy + "' ALLOW FILTERING") > 0;
    }

    private String getChangeLogLockTableName() {
        if (this.database.getLiquibaseCatalogName() != null) {
            return this.database.getLiquibaseCatalogName() + "." + this.database.getDatabaseChangeLogLockTableName();
        }
        return this.database.getDatabaseChangeLogLockTableName();
    }

    private int executeCountQuery(Executor executor, String query) throws DatabaseException {
        if (!query.contains("SELECT COUNT(*)")) {
            throw new UnexpectedLiquibaseException("Invalid count query: " + query);
        }
        if (CassandraDatabase.isAwsKeyspacesCompatibilityModeEnabled()) {
            Scope.getCurrentScope().getLog(LockServiceCassandra.class).fine("AWS Keyspaces compatibility mode enabled: using alternative count query");
            String altQuery = query.replaceAll("(?i)SELECT COUNT\\(\\*\\)", "SELECT *");
            List rows = executor.queryForList((SqlStatement)new RawSqlStatement(altQuery));
            return rows.size();
        }
        return executor.queryForInt((SqlStatement)new RawSqlStatement(query));
    }
}

