/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cassandra.sqlgenerator;

import liquibase.database.Database;
import liquibase.ext.cassandra.database.CassandraDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.SetTableRemarksGenerator;
import liquibase.statement.core.SetTableRemarksStatement;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;

public class SetTableRemarksGeneratorCassandra
extends SetTableRemarksGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(SetTableRemarksStatement statement, Database database) {
        return database instanceof CassandraDatabase;
    }

    public Sql[] generateSql(SetTableRemarksStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String remarksEscaped = database.escapeStringForDatabase(StringUtil.trimToEmpty((String)statement.getRemarks()));
        String sql = "ALTER TABLE " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()) + " WITH comment = '" + remarksEscaped + "'";
        return new Sql[]{new UnparsedSql(sql, new DatabaseObject[]{this.getAffectedTable(statement)})};
    }
}

