/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cassandra.sqlgenerator;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.datatype.DataTypeFactory;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.ext.cassandra.database.CassandraDatabase;
import liquibase.ext.cassandra.lockservice.LockServiceCassandra;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.TagDatabaseGenerator;
import liquibase.statement.core.TagDatabaseStatement;
import liquibase.structure.DatabaseObject;

public class TagDatabaseGeneratorCassandra
extends TagDatabaseGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(TagDatabaseStatement statement, Database database) {
        return database instanceof CassandraDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sql[] generateSql(TagDatabaseStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ObjectQuotingStrategy currentStrategy = database.getObjectQuotingStrategy();
        database.setObjectQuotingStrategy(ObjectQuotingStrategy.LEGACY);
        try {
            ResultSet rs1;
            String tagEscaped = DataTypeFactory.getInstance().fromObject((Object)statement.getTag(), database).objectToSql((Object)statement.getTag(), database);
            Statement statement1 = ((CassandraDatabase)database).getStatement();
            String databaseChangelogTableName = database.escapeTableName(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName(), "databasechangelog");
            PreparedStatement ps1 = null;
            if (CassandraDatabase.isAwsKeyspacesCompatibilityModeEnabled()) {
                Scope.getCurrentScope().getLog(LockServiceCassandra.class).fine("AWS Keyspaces compatibility mode enabled: using alternative to get last executed changeset");
                Timestamp maxDateExecuted = this.selectLastExecutedChangesetTimestamp(database, databaseChangelogTableName);
                String query1 = "SELECT TOUNIXTIMESTAMP(DATEEXECUTED) as LAST_DATEEXECUTED FROM " + databaseChangelogTableName + "WHERE DATEEXECUTED = ? ALLOW FILTERING;";
                ps1 = ((CassandraDatabase)database).prepareStatement(query1);
                ps1.setTimestamp(1, maxDateExecuted);
                rs1 = ps1.executeQuery();
            } else {
                String query1 = "SELECT TOUNIXTIMESTAMP(MAX(DATEEXECUTED)) as LAST_DATEEXECUTED FROM " + databaseChangelogTableName;
                rs1 = statement1.executeQuery(query1);
            }
            String date = "";
            if (rs1 == null) {
                throw new UnexpectedLiquibaseException("Unexpected null result set when getting last executed changeset date");
            }
            while (rs1.next()) {
                date = rs1.getString("LAST_DATEEXECUTED");
            }
            rs1.close();
            if (ps1 != null) {
                ps1.close();
            }
            String query2 = "SELECT id, author, filename FROM " + databaseChangelogTableName + " WHERE dateexecuted = '" + date + "' ALLOW FILTERING";
            ResultSet rs2 = statement1.executeQuery(query2);
            String id = "";
            String author = "";
            String filename = "";
            while (rs2.next()) {
                id = rs2.getString("id");
                author = rs2.getString("author");
                filename = rs2.getString("filename");
            }
            rs2.close();
            statement1.close();
            String updateQuery = "UPDATE " + databaseChangelogTableName + " SET TAG = " + tagEscaped + " WHERE id = '" + id + "' AND author = '" + author + "' AND filename = '" + filename + "'";
            Sql[] sqlArray = new Sql[]{new UnparsedSql(updateQuery, new DatabaseObject[0])};
            return sqlArray;
        }
        catch (SQLException | DatabaseException e) {
            Sql[] sqlArray = super.generateSql(statement, database, sqlGeneratorChain);
            return sqlArray;
        }
        finally {
            database.setObjectQuotingStrategy(currentStrategy);
        }
    }

    private Timestamp selectLastExecutedChangesetTimestamp(Database database, String changelogTableName) throws SQLException, DatabaseException {
        Statement statement = ((CassandraDatabase)database).getStatement();
        ResultSet rs = statement.executeQuery("SELECT DATEEXECUTED FROM " + changelogTableName);
        Timestamp maxValue = null;
        while (rs.next()) {
            Timestamp result = rs.getTimestamp("DATEEXECUTED");
            if (maxValue != null && maxValue.compareTo(result) >= 0) continue;
            maxValue = result;
        }
        rs.close();
        statement.close();
        return maxValue;
    }
}

