/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cassandra.sqlgenerator;

import liquibase.database.Database;
import liquibase.ext.cassandra.database.CassandraDatabase;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.UnlockDatabaseChangeLogGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.UnlockDatabaseChangeLogStatement;
import liquibase.statement.core.UpdateStatement;

public class UnlockDatabaseChangeLogGeneratorCassandra
extends UnlockDatabaseChangeLogGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(UnlockDatabaseChangeLogStatement statement, Database database) {
        return database instanceof CassandraDatabase;
    }

    public Sql[] generateSql(UnlockDatabaseChangeLogStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        UpdateStatement releaseStatement = new UpdateStatement(database.getLiquibaseCatalogName(), null, database.getDatabaseChangeLogLockTableName());
        releaseStatement.addNewColumnValue("LOCKED", (Object)false);
        releaseStatement.addNewColumnValue("LOCKEDBY", null);
        releaseStatement.setWhereClause(database.escapeColumnName(database.getLiquibaseCatalogName(), null, database.getDatabaseChangeLogTableName(), "ID") + " = 1");
        return SqlGeneratorFactory.getInstance().generateSql((SqlStatement)releaseStatement, database);
    }
}

