/*
 * Decompiled with CFR 0.152.
 */
package com.liquibase.ext.change;

import com.liquibase.ext.statement.MongoshStatement;
import java.util.ArrayList;
import liquibase.change.AbstractSQLChange;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.statement.SqlStatement;
import liquibase.util.StringUtil;

@DatabaseChange(name="mongo", description="mongo", priority=1)
public class MongoshChange
extends AbstractSQLChange {
    public static final String CHANGE_NAME = "mongo";
    private String mongo;

    @DatabaseChangeProperty(serializationType=LiquibaseSerializable.SerializationType.DIRECT_VALUE)
    public String getMongo() {
        return this.mongo;
    }

    public void setMongo(String mongo) {
        this.mongo = mongo;
    }

    public String getConfirmationMessage() {
        return "Mongsh command executed";
    }

    public SqlStatement[] generateStatements(Database database) {
        String query;
        ArrayList<MongoshStatement> returnStatements = new ArrayList<MongoshStatement>();
        String string = query = this.getMongo() == null ? StringUtil.trimToNull((String)this.getSql()) : StringUtil.trimToNull((String)this.getMongo());
        if (query == null) {
            return SqlStatement.EMPTY_SQL_STATEMENT;
        }
        String processedSQL = this.normalizeLineEndings(query);
        returnStatements.add(new MongoshStatement(processedSQL, this.getEndDelimiter()));
        return returnStatements.toArray(SqlStatement.EMPTY_SQL_STATEMENT);
    }

    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors = new ValidationErrors();
        if (StringUtil.trimToNull((String)this.getSql()) == null && StringUtil.trimToNull((String)this.getMongo()) == null) {
            validationErrors.addError("command is required. Learn more at https://docs.liquibase.com/mongodb");
        }
        return validationErrors;
    }
}

