/*
 * Decompiled with CFR 0.152.
 */
package com.liquibase.ext.config;

import liquibase.configuration.AutoloadedConfigurations;
import liquibase.configuration.ConfigurationDefinition;

public class MongoShConfiguration
implements AutoloadedConfigurations {
    public static final ConfigurationDefinition<String> PATH;
    public static final ConfigurationDefinition<Integer> TIMEOUT;
    public static final ConfigurationDefinition<Boolean> TEMP_KEEP;
    public static final ConfigurationDefinition<String> TEMP_NAME;
    public static final ConfigurationDefinition<String> TEMP_PATH;
    public static final ConfigurationDefinition<String> ARGS;
    public static final ConfigurationDefinition<String> LOG_FILE;
    public static final ConfigurationDefinition<String> EXECUTOR;

    static {
        ConfigurationDefinition.Builder builder = new ConfigurationDefinition.Builder("liquibase.mongosh");
        PATH = builder.define("path", String.class).setDescription("Path to mongosh executable").build();
        TIMEOUT = builder.define("timeout", Integer.class).setDescription("Seconds to wait for mongosh timeout").build();
        TEMP_KEEP = builder.define("keep.temp", Boolean.class).setDescription("Retain generated temp files").build();
        TEMP_NAME = builder.define("keep.temp.name", String.class).setDescription("Optionally, specify a custom filename").build();
        TEMP_PATH = builder.define("keep.temp.path", String.class).setDescription("Optionally, specify the path in which to store the temporary files. If not specified, the files will be stored in the system's temp directory").build();
        LOG_FILE = builder.define("logFile", String.class).setDescription("Log file for psql output").build();
        ARGS = builder.define("args", String.class).setDescription("Extra arguments which will be passed to the psql executable").build();
        EXECUTOR = builder.define("executor", String.class).setDescription("Custom executor that can be specified").build();
    }

    public static class ConfigurationKeys {
        public static final String BASE = "liquibase.mongosh";
        public static final String KEEP_TEMP_BASE = "keep.temp";
        public static final String KEEP_TEMP_NAME = "keep.temp.name";
        public static final String KEEP_TEMP_PATH = "keep.temp.path";
        public static final String LOG_FILE = "logFile";
        public static final String EXECUTOR = "executor";

        public static String getFullKey(String keyName) {
            return "liquibase.mongosh." + keyName;
        }
    }
}

