/*
 * Decompiled with CFR 0.152.
 */
package com.liquibase.ext.tools;

import com.datical.liquibase.ext.tools.AbstractNativeToolExecutor;
import com.liquibase.ext.change.MongoshChange;
import com.liquibase.ext.change.MongoshFileChange;
import com.liquibase.ext.statement.MongoshStatement;
import com.liquibase.ext.tools.MongoshRunner;
import java.util.List;
import java.util.ResourceBundle;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.ValidationErrors;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.logging.Logger;
import liquibase.sql.Sql;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;

public class MongoshExecutor
extends AbstractNativeToolExecutor {
    private static ResourceBundle mongoshBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-mongosh");
    protected static final String MSG_UNABLE_TO_VALIDATE_CHANGE_SET = mongoshBundle.getString("unable.to.validate.changeset");
    private static String name = "mongosh";

    public MongoshExecutor() {
        super(name);
    }

    public String getName() {
        return name;
    }

    public int getPriority() {
        return 10;
    }

    public boolean supports(Database database) {
        return database instanceof MongoLiquibaseDatabase;
    }

    protected void validateChange(ChangeSet changeSet, ValidationErrors validationErrors, Change change, String type) {
        if (!(change instanceof MongoshChange) && !(change instanceof MongoshFileChange)) {
            String details = "In changeset '" + changeSet.getId() + "::" + changeSet.getAuthor() + "' there is an unsupported change type '" + change.toString() + "'";
            String message = String.format(MSG_UNABLE_TO_VALIDATE_CHANGE_SET, details, type, name, "mongo", "mongoFile");
            validationErrors.addError(message);
        }
    }

    public void execute(SqlStatement noSqlStatement, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        Logger log = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        if (!(noSqlStatement instanceof MongoshStatement)) {
            log.warning("statement should be type or subtype of MongoshStatement, but is " + noSqlStatement.getClass() + ". Learn more at https://docs.liquibase.com/mongodb");
        }
        log.info("Executing with the '" + this.getName() + "' executor");
        Sql[] nosqlStatements = SqlGeneratorFactory.getInstance().generateSql(noSqlStatement, this.database);
        try {
            MongoshRunner runner = new MongoshRunner(this.changeSet, null);
            runner.executeCommand(this.database);
            log.info("Successfully validated mongosh");
            runner = new MongoshRunner(this.changeSet, nosqlStatements);
            runner.executeCommand(this.database);
            log.info(String.format("Success! Changeset '%s' by '%s' deployed by mongosh", this.changeSet.getId(), this.changeSet.getAuthor()));
        }
        catch (Exception e) {
            log.warning(String.format("%nChangeset '%s' by '%s' failed to deploy with 'mongosh'. Please check mongosh logs", this.changeSet.getId(), this.changeSet.getAuthor()) + ". Learn more at https://docs.liquibase.com/mongodb");
            throw new DatabaseException((Throwable)e);
        }
    }
}

