/*
 * Decompiled with CFR 0.152.
 */
package com.liquibase.ext.tools;

import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.exception.CommandExecutionException;
import liquibase.logging.Logger;
import liquibase.util.FilenameUtil;
import liquibase.util.StringUtil;

public class MongoshFileCreator {
    private final ChangeSet changeSet;
    private final String filenameOverride;
    private final String pathOverride;
    private final boolean overwriteFile;
    private final boolean keepFile;

    public MongoshFileCreator(ChangeSet changeSet, String filenameOverride, String pathOverride, boolean overwriteFile, boolean keepFile) {
        this.changeSet = changeSet;
        this.filenameOverride = filenameOverride;
        this.pathOverride = pathOverride;
        this.overwriteFile = overwriteFile;
        this.keepFile = keepFile;
    }

    public File generateTemporaryFile(String fileType) throws Exception {
        Logger log = Scope.getCurrentScope().getLog(this.getClass());
        Object tempFileName = "liquibase-" + fileType + "-" + this.changeSet.getId() + "-" + this.changeSet.getAuthor() + "-";
        if (StringUtil.isNotEmpty((String)this.filenameOverride)) {
            tempFileName = this.filenameOverride;
        }
        tempFileName = FilenameUtil.sanitizeFileName((String)tempFileName);
        log.info("Creating temporary " + fileType + " file for '" + (String)tempFileName + "'");
        if (StringUtil.isEmpty((String)this.pathOverride)) {
            String tempDirectoryPath = System.getProperty("java.io.tmpdir");
            if (StringUtil.isEmpty((String)this.filenameOverride)) {
                return this.deleteFileOnExitIfNeeded(File.createTempFile((String)tempFileName, fileType), this.keepFile);
            }
            File f = new File(tempDirectoryPath, this.filenameOverride + fileType);
            return this.deleteFileOnExitIfNeeded(this.safelyCreateNewFile(f, this.overwriteFile), this.keepFile);
        }
        File parentDirectory = new File(this.pathOverride);
        boolean wasDirectoryCreated = parentDirectory.mkdirs();
        if (!this.keepFile && wasDirectoryCreated) {
            parentDirectory.deleteOnExit();
        }
        if (StringUtil.isEmpty((String)this.filenameOverride)) {
            SecureRandom secureRandom = new SecureRandom();
            File f = new File(this.pathOverride, (String)tempFileName + secureRandom.nextLong() + fileType);
            return this.deleteFileOnExitIfNeeded(this.safelyCreateNewFile(f, this.overwriteFile), this.keepFile);
        }
        File f = new File(this.pathOverride, this.filenameOverride + fileType);
        return this.deleteFileOnExitIfNeeded(this.safelyCreateNewFile(f, this.overwriteFile), this.keepFile);
    }

    private File safelyCreateNewFile(File f, Boolean shouldOverwriteFile) throws CommandExecutionException, IOException {
        if (!f.exists()) {
            return this.createNewFile(f);
        }
        if (f.exists() && shouldOverwriteFile == null) {
            throw new CommandExecutionException("ERROR: Specified Mongosh file " + f.getAbsolutePath() + " already exists, and liquibase.mongosh.keep.temp.overwrite=NULL. It is unclear whether the file should be overwritten. To run this job, either adjust file name or path, or set liquibase.mongosh.keep.temp.overwrite=TRUE. Learn more at https://docs.liquibase.com/mongodb");
        }
        if (f.exists() && !shouldOverwriteFile.booleanValue()) {
            throw new CommandExecutionException("ERROR: Specified Mongosh file " + f.getAbsolutePath() + " already exists, and liquibase.mongosh.keep.temp.overwrite=FALSE. To run this job, either adjust file name or path, or set liquibase.mongosh.keep.temp.overwrite=TRUE. Learn more at https://docs.liquibase.com/mongodb");
        }
        Scope.getCurrentScope().getUI().sendMessage("WARNING: Specified Mongosh file " + f.getAbsolutePath() + " already existed, and was overwritten. Learn more at https://docs.liquibase.com/mongodb");
        boolean deletedSuccessfully = f.delete();
        if (deletedSuccessfully) {
            return this.createNewFile(f);
        }
        throw new CommandExecutionException("Failed to create file " + f.getAbsolutePath() + " after deleting existing file. Learn more at https://docs.liquibase.com/mongodb");
    }

    private File createNewFile(File f) throws IOException, CommandExecutionException {
        boolean created = f.createNewFile();
        if (created) {
            return f;
        }
        throw new CommandExecutionException("Failed to create file " + f.getAbsolutePath() + ". Learn more at https://docs.liquibase.com/mongodb");
    }

    private File deleteFileOnExitIfNeeded(File f, Boolean keepFile) {
        if (!keepFile.booleanValue()) {
            f.deleteOnExit();
        }
        return f;
    }
}

