/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.precondition;

import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.database.Database;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.ext.mongodb.statement.BsonUtils;
import liquibase.ext.mongodb.statement.CountDocumentsInCollectionStatement;
import liquibase.precondition.AbstractPrecondition;
import liquibase.precondition.Precondition;
import org.bson.Document;

public class ExpectedDocumentCountPrecondition
extends AbstractPrecondition {
    private String collectionName;
    private String filter;
    private Long expectedCount;

    public String getName() {
        return "expectedDocumentCount";
    }

    public Warnings warn(Database database) {
        return new Warnings();
    }

    public ValidationErrors validate(Database database) {
        return new ValidationErrors();
    }

    public void check(Database database, DatabaseChangeLog changeLog, ChangeSet changeSet, ChangeExecListener changeExecListener) throws PreconditionFailedException, PreconditionErrorException {
        try {
            Document bsonFilter = BsonUtils.orEmptyDocument(this.filter);
            CountDocumentsInCollectionStatement countDocumentsInCollectionStatement = new CountDocumentsInCollectionStatement(this.collectionName, bsonFilter);
            Long actualDocumentCount = countDocumentsInCollectionStatement.queryForLong((MongoLiquibaseDatabase)database);
            if (!actualDocumentCount.equals(this.expectedCount)) {
                throw new PreconditionFailedException(String.format("ExpectedDocumentCount precondition fails for collection %s, expected: %s, actual: %s", this.collectionName, this.expectedCount, actualDocumentCount), changeLog, (Precondition)this);
            }
        }
        catch (PreconditionFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PreconditionErrorException(e, changeLog, (Precondition)this);
        }
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog-ext";
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public Long getExpectedCount() {
        return this.expectedCount;
    }

    public void setExpectedCount(Long expectedCount) {
        this.expectedCount = expectedCount;
    }
}

