/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.statement;

import com.mongodb.MongoException;
import com.mongodb.client.MongoDatabase;
import java.util.List;
import java.util.Objects;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.ext.mongodb.statement.AbstractMongoStatement;
import liquibase.ext.mongodb.statement.BsonUtils;
import liquibase.nosql.statement.NoSqlExecuteStatement;
import org.bson.Document;

public abstract class AbstractRunCommandStatement
extends AbstractMongoStatement
implements NoSqlExecuteStatement<MongoLiquibaseDatabase> {
    public static final String COMMAND_NAME = "runCommand";
    public static final String SHELL_DB_PREFIX = "db.";
    public static final String OK = "ok";
    public static final String WRITE_ERRORS = "writeErrors";
    protected final Document command;

    @Override
    public void execute(MongoLiquibaseDatabase database) {
        this.run(database);
    }

    public Document run(MongoLiquibaseDatabase database) {
        return this.run(database.getMongoDatabase());
    }

    public Document run(MongoDatabase mongoDatabase) {
        Document response = mongoDatabase.runCommand(this.command);
        this.checkResponse(response);
        return response;
    }

    protected void checkResponse(Document responseDocument) throws MongoException {
        Double ok = responseDocument.get(OK) instanceof Integer ? (double)responseDocument.getInteger(OK).intValue() : responseDocument.getDouble(OK);
        List<Document> writeErrors = responseDocument.getList(WRITE_ERRORS, Document.class);
        if (Objects.nonNull(ok) && !ok.equals(1.0) || Objects.nonNull(writeErrors) && !writeErrors.isEmpty()) {
            throw new MongoException("Command failed. The full response is " + responseDocument.toJson());
        }
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    public abstract String getRunCommandName();

    @Override
    public String toJs() {
        return SHELL_DB_PREFIX + this.getCommandName() + "(" + BsonUtils.toJson(this.command) + ");";
    }

    public AbstractRunCommandStatement(Document command) {
        this.command = command;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractRunCommandStatement)) {
            return false;
        }
        AbstractRunCommandStatement other = (AbstractRunCommandStatement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Document this$command = this.getCommand();
        Document other$command = other.getCommand();
        return !(this$command == null ? other$command != null : !((Object)this$command).equals(other$command));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractRunCommandStatement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Document $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : ((Object)$command).hashCode());
        return result;
    }

    public Document getCommand() {
        return this.command;
    }
}

