/*
 * Decompiled with CFR 0.152.
 */
package com.liquibase.ext.parser;

import com.datical.liquibase.ext.parser.ProFormattedSqlChangeLogParser;
import com.liquibase.ext.change.MongoshChange;
import com.liquibase.ext.parser.ChangeLogErrorHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.exception.ChangeLogParseException;
import liquibase.exception.SetupException;
import liquibase.license.LicenseServiceUtils;
import liquibase.parser.AbstractFormattedChangeLogParser;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.ParsedNodeException;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtil;

public class FormattedMongoshChangeLogParser
extends AbstractFormattedChangeLogParser {
    private static final ResourceBundle mongoshBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-mongosh");
    private static final String PRECONDITIONS_ARE_NOT_SUPPORTED = mongoshBundle.getString("preconditions.are.not.supported");
    private final String FIRST_LINE_MONGOSH_REGEX = String.format("^\\s*%s\\s*liquibase\\s*formatted\\s*mongodb|^\\s*%s\\s*liquibase\\s*formatted\\s*mongo", this.getSingleLineCommentSequence(), this.getSingleLineCommentSequence());
    private final Pattern FIRST_LINE_MONGOSH_PATTERN = Pattern.compile(this.FIRST_LINE_MONGOSH_REGEX, 2);
    public static final String INCLUDE_ALL = "includeAll";
    public static final String INCLUDE = "include";
    protected final String INCLUDE_REGEX = String.format("\\s*%s[\\s]*include[\\s]+(.*)", this.getSingleLineCommentSequence());
    protected final Pattern INCLUDE_PATTERN = Pattern.compile(this.INCLUDE_REGEX, 2);
    protected final String INCLUDE_ALL_REGEX = String.format("\\s*%s[\\s]*includeAll[\\s]+(.*)", this.getSingleLineCommentSequence());
    protected final Pattern INCLUDE_ALL_PATTERN = Pattern.compile(this.INCLUDE_ALL_REGEX, 2);
    protected static final String INCLUDE_FILE_REGEX = ".*?file:\\s*\"?([^\"\\s]*)\"?.*";
    protected final Pattern INCLUDE_FILE_PATTERN = Pattern.compile(".*?file:\\s*\"?([^\"\\s]*)\"?.*", 2);
    protected final Pattern IGNORE_CHANGESET_PATTERN = Pattern.compile(".*ignore:(\\w*).*", 2);
    protected static final String ERROR_IF_MISSING_REGEX = ".*errorIfMissing:(\\w+).*";
    protected final Pattern ERROR_IF_MISSING_PATTERN = Pattern.compile(".*errorIfMissing:(\\w+).*", 2);
    protected static final String RELATIVE_TO_CHANGELOG_REGEX = ".*relativeToChangelog:\\s*(\".*?\"|\\S*).*";
    protected final Pattern RELATIVE_TO_CHANGELOG_PATTERN = Pattern.compile(".*relativeToChangelog:\\s*(\".*?\"|\\S*).*", 2);
    protected static final String INCLUDE_ALL_PATH_REGEX = ".*?path:\\s*\"?([^\\s\"]+)\"?.*";
    protected final Pattern INCLUDE_ALL_PATH_PATTERN = Pattern.compile(".*?path:\\s*\"?([^\\s\"]+)\"?.*", 2);
    protected static final String FILTER_REGEX = ".*\\s+filter:\\s*(\".*?\"|\\S*).*";
    protected final Pattern FILTER_PATTERN = Pattern.compile(".*\\s+filter:\\s*(\".*?\"|\\S*).*", 2);
    protected static final String ERROR_IF_MISSING_OR_EMPTY_REGEX = ".*errorIfMissingOrEmpty:(\\w+).*";
    protected final Pattern ERROR_IF_MISSING_OR_EMPTY_PATTERN = Pattern.compile(".*errorIfMissingOrEmpty:(\\w+).*", 2);
    protected static final String RESOURCE_FILTER_REGEX = ".*resourceFilter:\\s*(\".*?\"|\\S*).*";
    protected final Pattern RESOURCE_FILTER_PATTERN = Pattern.compile(".*resourceFilter:\\s*(\".*?\"|\\S*).*", 2);
    protected static final String RESOURCE_COMPARATOR_DEF_REGEX = ".*\\s+filter:\\s*(\".*?\"|\\S*).*";
    protected final Pattern RESOURCE_COMPARATOR_DEF_PATTERN = Pattern.compile(".*\\s+filter:\\s*(\".*?\"|\\S*).*", 2);
    protected static final String MIN_DEPTH_REGEX = ".*minDepth:\\s*(\".*?\"|\\S*).*";
    protected final Pattern MIN_DEPTH_PATTERN = Pattern.compile(".*minDepth:\\s*(\".*?\"|\\S*).*", 2);
    protected static final String MAX_DEPTH_REGEX = ".*maxDepth:\\s*(\".*?\"|\\S*).*";
    protected final Pattern MAX_DEPTH_PATTERN = Pattern.compile(".*maxDepth:\\s*(\".*?\"|\\S*).*", 2);
    protected static final String ENDS_WITH_FILTER_REGEX = ".*endsWithFilter:\\s*(\".*?\"|\\S*).*";
    protected final Pattern ENDS_WITH_FILTER_PATTERN = Pattern.compile(".*endsWithFilter:\\s*(\".*?\"|\\S*).*", 2);

    protected String getSingleLineCommentOneCharacter() {
        return "/";
    }

    protected String getSingleLineCommentSequence() {
        return "//";
    }

    protected String getStartMultiLineCommentSequence() {
        return "/\\*";
    }

    protected String getEndMultiLineCommentSequence() {
        return "\\*/";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean supports(String string, ResourceAccessor object) {
        try {
            object = new BufferedReader(StreamUtil.readStreamWithReader((InputStream)this.openChangeLogFile(string, (ResourceAccessor)object), null));
            try {
                if (!this.supportsExtension(string)) return false;
                String string2 = ((BufferedReader)object).readLine();
                while (string2 != null && string2.trim().isEmpty() && ((BufferedReader)object).ready()) {
                    string2 = ((BufferedReader)object).readLine();
                }
                if (StringUtil.isEmpty((String)string2)) {
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning(String.format("Skipping empty file '%s'", string));
                    return false;
                }
                boolean bl = this.FIRST_LINE_MONGOSH_PATTERN.matcher(string2).matches();
                return bl;
            }
            finally {
                ((BufferedReader)object).close();
            }
        }
        catch (IOException iOException) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).fine("Exception reading " + string, (Throwable)iOException);
            return false;
        }
    }

    protected boolean supportsExtension(String string) {
        return string.toLowerCase().endsWith(".js");
    }

    protected void handlePreconditionCase(ChangeLogParameters object, ChangeSet changeSet, Matcher matcher) {
        if (matcher.groupCount() == 2 && (object = StringUtil.trimToNull((String)matcher.group(1))) != null) {
            throw new ChangeLogParseException(String.format(PRECONDITIONS_ARE_NOT_SUPPORTED, new Object[0]));
        }
    }

    protected void handlePreconditionsCase(ChangeSet object, int n, Matcher matcher) {
        if (matcher.groupCount() == 1 && (object = StringUtil.trimToNull((String)matcher.group(1))) != null) {
            throw new ChangeLogParseException(String.format(PRECONDITIONS_ARE_NOT_SUPPORTED, new Object[0]));
        }
    }

    protected AbstractSQLChange getChange() {
        return new MongoshChange();
    }

    protected String getDocumentationLink() {
        return "https://docs.liquibase.com/mongodb";
    }

    protected String getSequenceName() {
        return "Mongosh";
    }

    protected void setChangeSequence(AbstractSQLChange abstractSQLChange, String string) {
        if (abstractSQLChange instanceof MongoshChange) {
            ((MongoshChange)abstractSQLChange).setMongo(string);
            abstractSQLChange.setSql(string);
        }
    }

    protected boolean isNotEndDelimiter(AbstractSQLChange abstractSQLChange) {
        if (abstractSQLChange instanceof MongoshChange) {
            return abstractSQLChange.getEndDelimiter() == null && StringUtil.trimToEmpty((String)((MongoshChange)abstractSQLChange).getMongo()).endsWith("\n/");
        }
        return false;
    }

    protected void setChangeSequence(ChangeLogParameters object, StringBuilder stringBuilder, ChangeSet changeSet, AbstractSQLChange abstractSQLChange) {
        if (abstractSQLChange instanceof MongoshChange) {
            object = object.expandExpressions(StringUtil.trimToNull((String)stringBuilder.toString()), changeSet.getChangeLog());
            ((MongoshChange)abstractSQLChange).setMongo((String)object);
            abstractSQLChange.setSql((String)object);
        }
    }

    public DatabaseChangeLog parse(String string, ChangeLogParameters changeLogParameters, ResourceAccessor resourceAccessor) {
        changeLogParameters = super.parse(string, changeLogParameters, resourceAccessor);
        return ChangeLogErrorHandler.parse((DatabaseChangeLog)changeLogParameters, string, "runWith:mongosh");
    }

    protected boolean handleAdditionalLines(DatabaseChangeLog object, ResourceAccessor resourceAccessor, String object2) {
        Matcher matcher = this.INCLUDE_PATTERN.matcher((CharSequence)object2);
        boolean bl = matcher.matches();
        object2 = this.INCLUDE_ALL_PATTERN.matcher((CharSequence)object2);
        boolean bl2 = ((Matcher)object2).matches();
        if (!bl && !bl2) {
            return false;
        }
        if (!LicenseServiceUtils.isProLicenseValid()) {
            object = bl ? INCLUDE : INCLUDE_ALL;
            object = String.format("ERROR: Using %s with formatted mongodb requires a valid Liquibase Pro key. Get a free license key at https://liquibase.com/trial. Add liquibase.licenseKey=<yourKey> into your defaults file or use --license-key=<yourKey> before your command in the CLI.", object);
            throw new ChangeLogParseException((String)object);
        }
        if (bl) {
            return this.handleInclude((DatabaseChangeLog)object, resourceAccessor, matcher);
        }
        return this.handleIncludeAll((DatabaseChangeLog)object, resourceAccessor, (Matcher)object2);
    }

    private boolean handleInclude(DatabaseChangeLog databaseChangeLog, ResourceAccessor resourceAccessor, Matcher object) {
        ParsedNode parsedNode = new ParsedNode(null, INCLUDE);
        Matcher matcher = this.INCLUDE_FILE_PATTERN.matcher((CharSequence)(object = ((Matcher)object).group(1)));
        if (!matcher.matches()) {
            return false;
        }
        Scope.getCurrentScope().getLog(ProFormattedSqlChangeLogParser.class).fine("Matched include tag");
        this.addNode(parsedNode, this.createChildNode("file", this.INCLUDE_FILE_PATTERN.matcher((CharSequence)object)));
        matcher = this.determineContextMatcher((String)object);
        String string = this.determineContextDescription(matcher);
        this.addNode(parsedNode, this.createChildNode(string, matcher, databaseChangeLog));
        this.addNode(parsedNode, this.createChildNode("labels", LABELS_PATTERN.matcher((CharSequence)object), databaseChangeLog));
        this.addNode(parsedNode, this.createChildNode("ignore", this.IGNORE_CHANGESET_PATTERN.matcher((CharSequence)object)));
        this.addNode(parsedNode, this.createChildNode("errorIfMissing", this.ERROR_IF_MISSING_PATTERN.matcher((CharSequence)object)));
        this.addNode(parsedNode, this.createChildNode("relativeToChangelogFile", this.RELATIVE_TO_CHANGELOG_PATTERN.matcher((CharSequence)object)));
        try {
            databaseChangeLog.handleChildNodeHelper(parsedNode, resourceAccessor, new HashMap());
        }
        catch (SetupException | ParsedNodeException throwable) {
            throw new ChangeLogParseException("Error processing include node: " + throwable.getMessage(), throwable);
        }
        return true;
    }

    private boolean handleIncludeAll(DatabaseChangeLog databaseChangeLog, ResourceAccessor resourceAccessor, Matcher object) {
        ParsedNode parsedNode = new ParsedNode(null, INCLUDE_ALL);
        Matcher matcher = this.INCLUDE_ALL_PATH_PATTERN.matcher((CharSequence)(object = ((Matcher)object).group(1)));
        if (!matcher.matches()) {
            return false;
        }
        Scope.getCurrentScope().getLog(ProFormattedSqlChangeLogParser.class).fine("Matched includeAll tag");
        this.addNode(parsedNode, this.createChildNode("path", this.INCLUDE_ALL_PATH_PATTERN.matcher((CharSequence)object)));
        this.addNode(parsedNode, this.createChildNode("relativeToChangelogFile", this.RELATIVE_TO_CHANGELOG_PATTERN.matcher((CharSequence)object)));
        this.addNode(parsedNode, this.createChildNode("resourceFilter", this.determineResourceFilterMatcher((String)object)));
        this.addNode(parsedNode, this.createChildNode("errorIfMissingOrEmpty", this.ERROR_IF_MISSING_OR_EMPTY_PATTERN.matcher((CharSequence)object)));
        this.addNode(parsedNode, this.createChildNode("resourceComparator", this.RESOURCE_COMPARATOR_DEF_PATTERN.matcher((CharSequence)object)));
        matcher = this.determineContextMatcher((String)object);
        String string = this.determineContextDescription(matcher);
        this.addNode(parsedNode, this.createChildNode(string, matcher, databaseChangeLog));
        this.addNode(parsedNode, this.createChildNode("labels", LABELS_PATTERN.matcher((CharSequence)object)));
        this.addNode(parsedNode, this.createChildNode("ignore", this.IGNORE_CHANGESET_PATTERN.matcher((CharSequence)object)));
        this.addNode(parsedNode, this.createChildNode("minDepth", this.determineMinDepth((String)object)));
        this.addNode(parsedNode, this.createChildNode("maxDepth", this.determineMaxDepth((String)object)));
        this.addNode(parsedNode, this.createChildNode("endsWithFilter", this.ENDS_WITH_FILTER_PATTERN.matcher((CharSequence)object)));
        try {
            databaseChangeLog.handleChildNodeHelper(parsedNode, resourceAccessor, new HashMap());
        }
        catch (SetupException | ParsedNodeException throwable) {
            throw new ChangeLogParseException("Error processing includeAll node: " + throwable.getMessage(), throwable);
        }
        return true;
    }

    private void addNode(ParsedNode parsedNode, ParsedNode parsedNode2) {
        try {
            if (parsedNode2 != null) {
                parsedNode.addChild(parsedNode2);
            }
            return;
        }
        catch (ParsedNodeException parsedNodeException) {
            throw new ChangeLogParseException("Error adding child node '" + parsedNode2.getName() + "' " + parsedNodeException.getMessage(), (Throwable)parsedNodeException);
        }
    }

    private ParsedNode createChildNode(String string, Matcher matcher) {
        return this.createChildNode(string, matcher, null);
    }

    private ParsedNode createChildNode(String string, Matcher object, DatabaseChangeLog databaseChangeLog) {
        try {
            object = this.getValueFromMatcher((Matcher)object);
            if (object != null) {
                if (databaseChangeLog != null) {
                    object = databaseChangeLog.getChangeLogParameters().expandExpressions(StringUtil.stripEnclosingQuotes((String)object), databaseChangeLog);
                }
                this.logMatch(string, (String)object, ((Object)((Object)this)).getClass());
                databaseChangeLog = new ParsedNode(null, string);
                databaseChangeLog.setValue(object);
                return databaseChangeLog;
            }
        }
        catch (ParsedNodeException parsedNodeException) {
            throw new ChangeLogParseException("Error processing child node: '" + string + "' " + parsedNodeException.getMessage(), (Throwable)parsedNodeException);
        }
        return null;
    }

    private String getValueFromMatcher(Matcher matcher) {
        if (matcher != null && matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private Matcher determineContextMatcher(String object) {
        Matcher matcher = CONTEXT_FILTER_PATTERN.matcher((CharSequence)object);
        if (matcher.matches()) {
            return matcher;
        }
        if (((Matcher)(object = CONTEXT_PATTERN.matcher((CharSequence)object))).matches()) {
            return object;
        }
        return null;
    }

    private String determineContextDescription(Matcher matcher) {
        String string = null;
        if (matcher != null) {
            string = matcher.pattern() == CONTEXT_PATTERN ? "context" : "contextFilter";
        }
        return string;
    }

    private Matcher determineResourceFilterMatcher(String object) {
        Matcher matcher = this.FILTER_PATTERN.matcher((CharSequence)object);
        if (matcher.matches()) {
            return matcher;
        }
        if (((Matcher)(object = this.RESOURCE_FILTER_PATTERN.matcher((CharSequence)object))).matches()) {
            return object;
        }
        return null;
    }

    private ParsedNode createChildNode(String string, Integer n) {
        try {
            if (n != null) {
                this.logMatch(string, n.toString(), ((Object)((Object)this)).getClass());
                ParsedNode parsedNode = new ParsedNode(null, string);
                parsedNode.setValue((Object)n);
                return parsedNode;
            }
        }
        catch (ParsedNodeException parsedNodeException) {
            throw new ChangeLogParseException("Error processing child node: '" + string + "' " + parsedNodeException.getMessage(), (Throwable)parsedNodeException);
        }
        return null;
    }

    private Integer determineMinDepth(String object) {
        Integer n = null;
        if (((Matcher)(object = this.MIN_DEPTH_PATTERN.matcher((CharSequence)object))).matches()) {
            object = ((Matcher)object).group(1);
            try {
                n = Integer.parseInt((String)object);
                if (n < 0) {
                    throw new ChangeLogParseException("Illegal min depth value of '" + (String)object + "'.  The value must be > 0.");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ChangeLogParseException("Invalid min depth value of '" + (String)object + "'.  The value must be a valid integer > 0");
            }
        }
        return n;
    }

    private Integer determineMaxDepth(String object) {
        Integer n = null;
        if (((Matcher)(object = this.MAX_DEPTH_PATTERN.matcher((CharSequence)object))).matches()) {
            object = ((Matcher)object).group(1);
            try {
                n = Integer.parseInt((String)object);
                if (n < 0) {
                    throw new ChangeLogParseException("Illegal max depth value of '" + (String)object + "'.  The value must be > 0.");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ChangeLogParseException("Invalid max depth value of '" + (String)object + "'.  The value must be a valid integer < MAX_VALUE");
            }
        }
        return n;
    }
}

