/*
 * Decompiled with CFR 0.152.
 */
package com.liquibase.ext.snapshot.jvm;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.license.LicenseServiceUtils;
import liquibase.nosql.snapshot.NoSqlSnapshotGenerator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.SnapshotGenerator;
import liquibase.snapshot.SnapshotGeneratorChain;
import liquibase.structure.DatabaseObject;

public abstract class AbstractMongoDbSnapshotGenerator
implements SnapshotGenerator {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final Class<? extends DatabaseObject> defaultFor;
    private final Class<? extends DatabaseObject>[] addsTo;

    protected AbstractMongoDbSnapshotGenerator(Class<? extends DatabaseObject> clazz, Class<? extends DatabaseObject>[] classArray) {
        this.defaultFor = clazz;
        this.addsTo = classArray;
    }

    public int getPriority(Class<? extends DatabaseObject> clazz, Database classArray) {
        if (classArray instanceof MongoLiquibaseDatabase) {
            if (!LicenseServiceUtils.isProLicenseValid()) {
                return -1;
            }
            if (this.defaultFor != null && this.defaultFor.isAssignableFrom(clazz)) {
                return 12;
            }
            if (this.addsTo() != null) {
                for (Class<? extends DatabaseObject> clazz2 : this.addsTo()) {
                    if (!clazz2.isAssignableFrom(clazz)) continue;
                    return 50;
                }
            }
        }
        return -1;
    }

    public DatabaseObject snapshot(DatabaseObject databaseObject, DatabaseSnapshot databaseSnapshot, SnapshotGeneratorChain snapshotGeneratorChain) {
        if (this.defaultFor != null && this.defaultFor.isAssignableFrom(databaseObject.getClass())) {
            return this.snapshotObject(databaseObject, databaseSnapshot);
        }
        if ((snapshotGeneratorChain = snapshotGeneratorChain.snapshot(databaseObject, databaseSnapshot)) == null) {
            return null;
        }
        if (this.shouldAddTo(databaseSnapshot) && this.addsTo() != null) {
            for (Class<? extends DatabaseObject> clazz : this.addsTo()) {
                if (!clazz.isAssignableFrom(databaseObject.getClass())) continue;
                this.addTo((DatabaseObject)snapshotGeneratorChain, databaseSnapshot);
            }
        }
        return snapshotGeneratorChain;
    }

    protected String objectAsString(Object object) {
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new DatabaseException("Error processing collection element definition", (Throwable)jsonProcessingException);
        }
    }

    protected boolean shouldAddTo(DatabaseSnapshot databaseSnapshot) {
        return this.defaultFor != null && databaseSnapshot.getSnapshotControl().shouldInclude(this.defaultFor);
    }

    protected abstract DatabaseObject snapshotObject(DatabaseObject var1, DatabaseSnapshot var2);

    protected abstract void addTo(DatabaseObject var1, DatabaseSnapshot var2);

    public Class<? extends DatabaseObject>[] addsTo() {
        return this.addsTo;
    }

    public Class<? extends SnapshotGenerator>[] replaces() {
        return new Class[]{NoSqlSnapshotGenerator.class};
    }
}

