/*
 * Decompiled with CFR 0.152.
 */
package com.liquibase.ext.snapshot.jvm;

import com.liquibase.ext.snapshot.jvm.AbstractMongoDbSnapshotGenerator;
import com.liquibase.ext.structure.Collection;
import com.liquibase.ext.structure.DocumentSchema;
import com.liquibase.ext.structure.NoSqlRelation;
import java.util.List;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.structure.DatabaseObject;
import org.bson.Document;

public class DocumentSchemaSnapshotGeneratorMongoDB
extends AbstractMongoDbSnapshotGenerator {
    public DocumentSchemaSnapshotGeneratorMongoDB() {
        super(DocumentSchema.class, new Class[]{Collection.class});
    }

    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (database instanceof MongoLiquibaseDatabase) {
            return super.getPriority(clazz, database);
        }
        return -1;
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject databaseObject, DatabaseSnapshot databaseSnapshot) {
        if (databaseObject instanceof DocumentSchema) {
            return databaseObject;
        }
        throw new DatabaseException("Unexpected example of type " + databaseObject.getClass().getSimpleName());
    }

    @Override
    protected void addTo(DatabaseObject object2, DatabaseSnapshot object3) {
        if (!object3.getSnapshotControl().shouldInclude(DocumentSchema.class)) {
            return;
        }
        if (!(object2 instanceof Collection)) {
            return;
        }
        object2 = (Collection)((Object)object2);
        try {
            object3 = (List)object3.getScratchData("All collections of " + ((NoSqlRelation)((Object)object2)).getCatalog().getName());
            object3.stream().filter(arg_0 -> DocumentSchemaSnapshotGeneratorMongoDB.lambda$addTo$0((Collection)((Object)object2), arg_0)).map(document -> document.get("options")).filter(object -> object instanceof Document).map(object -> (Document)object).filter(document -> document.containsKey("validator") && document.get("validator") instanceof Document).map(document -> (Document)document.get("validator")).filter(document -> document.containsKey("$jsonSchema")).forEach(arg_0 -> this.lambda$addTo$7((Collection)((Object)object2), arg_0));
            return;
        }
        catch (Exception exception) {
            throw new DatabaseException("Error obtaining document schema for collection " + ((NoSqlRelation)((Object)object2)).getName(), (Throwable)exception);
        }
    }

    private void createDocumentSchemaFromJsonSchema(Collection collection, Document document) {
        document = (Document)document.get("$jsonSchema");
        DocumentSchema documentSchema = new DocumentSchema();
        documentSchema.setName(collection.getName() + " : schema");
        documentSchema.setRelation(collection);
        try {
            documentSchema.setDefinition(this.objectAsString(document));
            collection.setDocumentSchema(documentSchema);
            return;
        }
        catch (Exception exception) {
            throw new DatabaseException("Error processing JSON Schema", (Throwable)exception);
        }
    }

    private /* synthetic */ void lambda$addTo$7(Collection collection, Document document) {
        try {
            this.createDocumentSchemaFromJsonSchema(collection, document);
            return;
        }
        catch (DatabaseException databaseException) {
            throw new RuntimeException(databaseException);
        }
    }

    private static /* synthetic */ boolean lambda$addTo$0(Collection collection, Document document) {
        return document.get("name").equals(collection.getName());
    }
}

