/*
 * Decompiled with CFR 0.152.
 */
package com.liquibase.ext.snapshot.jvm;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liquibase.ext.snapshot.jvm.AbstractMongoDbSnapshotGenerator;
import com.liquibase.ext.statement.ListCollectionStatement;
import com.liquibase.ext.structure.MongoView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.executor.ExecutorService;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.nosql.executor.NoSqlExecutor;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import org.bson.Document;

public class ViewSnapshotGeneratorMongoDB
extends AbstractMongoDbSnapshotGenerator {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public ViewSnapshotGeneratorMongoDB() {
        super(MongoView.class, new Class[]{Catalog.class});
    }

    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (database instanceof MongoLiquibaseDatabase) {
            return super.getPriority(clazz, database);
        }
        return -1;
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject databaseObject, DatabaseSnapshot databaseSnapshot) {
        if (databaseObject == null || databaseObject.getName() == null || !(databaseObject instanceof MongoView)) {
            return null;
        }
        return databaseObject;
    }

    @Override
    protected void addTo(DatabaseObject databaseObject, DatabaseSnapshot databaseSnapshot) {
        if (!databaseSnapshot.getSnapshotControl().shouldInclude(MongoView.class)) {
            return;
        }
        if (databaseObject instanceof Catalog) {
            databaseObject = (Catalog)databaseObject;
            Object object2 = databaseSnapshot.getDatabase();
            try {
                object2 = (NoSqlExecutor)((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", (Database)object2);
                Object object3 = databaseSnapshot.getScratchData("All collections of " + databaseObject.getName());
                if (object3 == null) {
                    object3 = new ListCollectionStatement();
                    object2 = ((NoSqlExecutor)((Object)object2)).queryForList((SqlStatement)object3, Document.class).stream().filter(Document.class::isInstance).map(Document.class::cast).collect(Collectors.toList());
                    databaseSnapshot.setScratchData("All collections of " + databaseObject.getName(), object2);
                    object3 = object2;
                }
                object3 = (List)object3;
                object3.stream().filter(object -> {
                    String string = ((Document)object).getString("name");
                    object = ((Document)object).get("type");
                    return string != null && object != null && "view".equals(object.toString());
                }).forEach(arg_0 -> this.lambda$addTo$1((Catalog)databaseObject, arg_0));
                return;
            }
            catch (Exception exception) {
                throw new DatabaseException("Error obtaining views for catalog " + databaseObject.getName(), (Throwable)exception);
            }
        }
    }

    private /* synthetic */ void lambda$addTo$1(Catalog catalog, Document document) {
        try {
            Iterator iterator;
            MongoView mongoView = new MongoView();
            mongoView.setCatalog(catalog);
            mongoView.setName(document.getString("name"));
            if (document.containsKey("options") && document.get("options") instanceof Document && ((Document)((Object)(iterator = (Document)document.get("options")))).containsKey("pipeline") && ((Document)((Object)iterator)).get("pipeline") instanceof List) {
                iterator = (List)((Document)((Object)iterator)).get("pipeline");
                ArrayList<Object> arrayList = new ArrayList<Object>();
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    Object object = (Document)iterator.next();
                    object = ((Document)object).toJson();
                    object = OBJECT_MAPPER.readValue((String)object, Object.class);
                    arrayList.add(object);
                }
                mongoView.setViewDefinition(this.objectAsString(arrayList));
            }
            catalog.addDatabaseObject((DatabaseObject)mongoView);
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException("Error processing view: " + document.getString("name"), exception);
        }
    }
}

