/*
 * Decompiled with CFR 0.152.
 */
package com.liquibase.ext.statement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.ext.mongodb.statement.AbstractRunCommandStatement;
import liquibase.ext.mongodb.statement.BsonUtils;
import liquibase.nosql.statement.NoSqlQueryForListStatement;
import org.bson.Document;

public class ListCollectionStatement
extends AbstractRunCommandStatement
implements NoSqlQueryForListStatement<MongoLiquibaseDatabase, Document> {
    static final String RUN_COMMAND_NAME = "listCollections";
    public static final String FILTER = "filter";
    public static final String CURSOR = "cursor";
    public static final String FIRST_BATCH = "firstBatch";
    public static final String AUTHORIZED_COLLECTIONS = "authorizedCollections";

    public ListCollectionStatement() {
        this(new Document());
    }

    public ListCollectionStatement(Document document) {
        super(BsonUtils.toCommand(RUN_COMMAND_NAME, 1, ListCollectionStatement.combine(document)));
    }

    @Override
    public String getRunCommandName() {
        return RUN_COMMAND_NAME;
    }

    @Override
    public List<Document> queryForList(MongoLiquibaseDatabase object) {
        object = super.run((MongoLiquibaseDatabase)((Object)object));
        object = (List)((Object)((Document)((Object)((Document)object).get((Object)CURSOR, Document.class))).get((Object)FIRST_BATCH, List.class));
        return new ArrayList<Document>((Collection<Document>)object);
    }

    private static Document combine(Document document) {
        return new Document(FILTER, document).append(AUTHORIZED_COLLECTIONS, Boolean.TRUE);
    }
}

