/*
 * Decompiled with CFR 0.152.
 */
package com.liquibase.ext.tools;

import java.io.File;
import java.security.SecureRandom;
import java.util.Random;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.exception.CommandExecutionException;
import liquibase.util.FilenameUtil;
import liquibase.util.StringUtil;

public class MongoshFileCreator {
    private final ChangeSet changeSet;
    private final String filenameOverride;
    private final String pathOverride;
    private final boolean overwriteFile;
    private final boolean keepFile;

    public MongoshFileCreator(ChangeSet changeSet, String string, String string2, boolean bl, boolean bl2) {
        this.changeSet = changeSet;
        this.filenameOverride = string;
        this.pathOverride = string2;
        this.overwriteFile = bl;
        this.keepFile = bl2;
    }

    public File generateTemporaryFile(String object) {
        Object object2 = Scope.getCurrentScope().getLog(this.getClass());
        Object object3 = "liquibase-" + (String)object + "-" + this.changeSet.getId() + "-" + this.changeSet.getAuthor() + "-";
        if (StringUtil.isNotEmpty((String)this.filenameOverride)) {
            object3 = this.filenameOverride;
        }
        object3 = FilenameUtil.sanitizeFileName((String)object3);
        object2.info("Creating temporary " + (String)object + " file for '" + (String)object3 + "'");
        if (StringUtil.isEmpty((String)this.pathOverride)) {
            object2 = System.getProperty("java.io.tmpdir");
            if (StringUtil.isEmpty((String)this.filenameOverride)) {
                return this.deleteFileOnExitIfNeeded(File.createTempFile((String)object3, (String)object), this.keepFile);
            }
            File file = new File((String)object2, this.filenameOverride + (String)object);
            MongoshFileCreator mongoshFileCreator = this;
            return mongoshFileCreator.deleteFileOnExitIfNeeded(mongoshFileCreator.safelyCreateNewFile(file, this.overwriteFile), this.keepFile);
        }
        object2 = new File(this.pathOverride);
        boolean bl = ((File)object2).mkdirs();
        if (!this.keepFile && bl) {
            ((File)object2).deleteOnExit();
        }
        if (StringUtil.isEmpty((String)this.filenameOverride)) {
            object2 = new SecureRandom();
            object = new File(this.pathOverride, (String)object3 + ((Random)object2).nextLong() + (String)object);
            MongoshFileCreator mongoshFileCreator = this;
            return mongoshFileCreator.deleteFileOnExitIfNeeded(mongoshFileCreator.safelyCreateNewFile((File)object, this.overwriteFile), this.keepFile);
        }
        object2 = new File(this.pathOverride, this.filenameOverride + (String)object);
        MongoshFileCreator mongoshFileCreator = this;
        return mongoshFileCreator.deleteFileOnExitIfNeeded(mongoshFileCreator.safelyCreateNewFile((File)object2, this.overwriteFile), this.keepFile);
    }

    private File safelyCreateNewFile(File file, Boolean bl) {
        if (!file.exists()) {
            return this.createNewFile(file);
        }
        if (file.exists() && bl == null) {
            throw new CommandExecutionException("ERROR: Specified Mongosh file " + file.getAbsolutePath() + " already exists, and liquibase.mongosh.keep.temp.overwrite=NULL. It is unclear whether the file should be overwritten. To run this job, either adjust file name or path, or set liquibase.mongosh.keep.temp.overwrite=TRUE. Learn more at https://docs.liquibase.com/mongodb");
        }
        if (file.exists() && !bl.booleanValue()) {
            throw new CommandExecutionException("ERROR: Specified Mongosh file " + file.getAbsolutePath() + " already exists, and liquibase.mongosh.keep.temp.overwrite=FALSE. To run this job, either adjust file name or path, or set liquibase.mongosh.keep.temp.overwrite=TRUE. Learn more at https://docs.liquibase.com/mongodb");
        }
        Scope.getCurrentScope().getUI().sendMessage("WARNING: Specified Mongosh file " + file.getAbsolutePath() + " already existed, and was overwritten. Learn more at https://docs.liquibase.com/mongodb");
        boolean bl2 = file.delete();
        if (bl2) {
            return this.createNewFile(file);
        }
        throw new CommandExecutionException("Failed to create file " + file.getAbsolutePath() + " after deleting existing file. Learn more at https://docs.liquibase.com/mongodb");
    }

    private File createNewFile(File file) {
        boolean bl = file.createNewFile();
        if (bl) {
            return file;
        }
        throw new CommandExecutionException("Failed to create file " + file.getAbsolutePath() + ". Learn more at https://docs.liquibase.com/mongodb");
    }

    private File deleteFileOnExitIfNeeded(File file, Boolean bl) {
        if (!bl.booleanValue()) {
            file.deleteOnExit();
        }
        return file;
    }
}

