/*
 * Decompiled with CFR 0.152.
 */
package com.liquibase.ext.tools;

import com.datical.liquibase.ext.util.NativeRunnerUtil;
import com.liquibase.ext.config.MongoshConfiguration;
import com.liquibase.ext.config.MongoshConfiguration$ConfigurationKeys;
import com.liquibase.ext.tools.MongoshFileCreator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.TimeoutException;
import liquibase.Scope;
import liquibase.change.core.ExecuteShellCommandChange;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.ext.mongodb.database.MongoConnection;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.resource.ResourceAccessor;
import liquibase.servicelocator.LiquibaseService;
import liquibase.sql.Sql;
import liquibase.util.StringUtil;

@LiquibaseService(skip=true)
public class MongoshRunner
extends ExecuteShellCommandChange {
    private ChangeSet changeSet;
    private Sql[] sqlStrings;
    private File outFile = null;
    private Boolean keepTempFile = Boolean.FALSE;
    private List<String> args = new ArrayList<String>();
    private String tempName;
    private String tempPath;
    private String logFile;
    private Integer timeout;
    private File mongoshExec;
    private static final String EXECUTABLE_NAME = "mongosh";
    private static final String MONGOSH_CONF = "liquibase.mongosh.conf";
    private static final ResourceBundle mongoshBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-mongosh");
    private static final String MSG_UNABLE_TO_RUN_MONGOSH = mongoshBundle.getString("unable.to.run.mongosh");

    public MongoshRunner() {
    }

    public MongoshRunner(ChangeSet changeSet, Sql[] sqlArray) {
        this.changeSet = changeSet;
        this.sqlStrings = sqlArray;
        this.setTimeout("1800");
    }

    protected List<String> createFinalCommandArray(Database object) {
        this.loadMongoshProperties();
        List list = super.createFinalCommandArray((Database)object);
        try {
            this.writeSqlStrings();
        }
        catch (Exception exception) {
            throw new UnexpectedLiquibaseException((Throwable)exception);
        }
        if (!this.args.isEmpty()) {
            list.addAll(Collections.unmodifiableList(this.args));
        }
        if (this.sqlStrings != null) {
            object = (MongoLiquibaseDatabase)((Object)object);
            object = (MongoConnection)object.getConnection();
            list.add(((MongoConnection)object).getConnectionString().getConnectionString());
            if (this.outFile != null) {
                list.add("--file");
                list.add(this.outFile.getAbsolutePath());
            } else {
                list.add("--eval");
                list.add(this.sqlStrings[0].toSql());
            }
        } else {
            list.add("--version");
        }
        object = StringUtil.join((Collection)list, (String)" ");
        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("mongosh command:\n" + ((String)object).replaceAll("://.*:.*@", "://<credentials>@"));
        return list;
    }

    protected void processResult(int n, String string, String string2, Database database) {
        if (this.logFile != null && this.outFile != null) {
            try {
                if (!string2.isEmpty()) {
                    Files.write(Paths.get(this.logFile, new String[0]), string2.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                }
                if (!string.isEmpty()) {
                    Files.write(Paths.get(this.logFile, new String[0]), string.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                }
            }
            catch (IOException iOException) {
                throw new UnexpectedLiquibaseException((Throwable)iOException);
            }
        }
        if (n != 0 && !StringUtil.isEmpty((String)string2)) {
            String string3 = this.getCommandString() + " returned a code of " + n + "\n" + string2 + "Learn more at https://docs.liquibase.com/mongodb";
            throw new UnexpectedLiquibaseException(string3);
        }
        super.processResult(n, string, string2, database);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeSqlStrings() {
        if (this.sqlStrings == null || this.sqlStrings.length == 0) {
            return;
        }
        Object object = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        object.info("Creating the mongosh run script");
        object = new MongoshFileCreator(this.changeSet, this.tempName, this.tempPath, true, this.keepTempFile == null ? (Boolean)MongoshConfiguration.TEMP_KEEP.getDefaultValue() : this.keepTempFile);
        try {
            this.outFile = ((MongoshFileCreator)object).generateTemporaryFile(".txt");
        }
        catch (IOException iOException) {
            throw new UnexpectedLiquibaseException((Throwable)iOException);
        }
        object = Paths.get(this.outFile.getAbsolutePath(), new String[0]);
        object = Files.newBufferedWriter((Path)object, new OpenOption[0]);
        try {
            Sql[] sqlArray = this.sqlStrings;
            int n = this.sqlStrings.length;
            for (int i = 0; i < n; ++i) {
                Sql sql = sqlArray[i];
                String string2 = sql.toSql();
                string2 = string2.replace("\r", "");
                ((Writer)object).write(string2);
            }
            ((Writer)object).write(";\n");
            if (object == null) return;
        }
        catch (Throwable throwable) {
            if (object == null) throw throwable;
            try {
                ((BufferedWriter)object).close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ((BufferedWriter)object).close();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeCommand(Database object) {
        block10: {
            try {
                this.finalCommandArray = this.createFinalCommandArray((Database)object);
                super.executeCommand(object);
                if (this.outFile == null || !this.outFile.exists() || this.keepTempFile == null || !this.keepTempFile.booleanValue()) break block10;
            }
            catch (TimeoutException timeoutException) {
                try {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    this.processResult(0, null, null, (Database)object);
                    object = timeoutException.getMessage() + System.lineSeparator() + "Error: The mongosh executable failed to return a response with the configured timeout. Please check liquibase.mongosh.timeout specified in liquibase.mongosh.conf file, the LIQUIBASE_MONGOSH_TIMEOUT environment variable, or other config locations. Learn more at https://docs.liquibase.com/concepts/advanced/runwith.html and https://docs.liquibase.com/mongodb" + System.lineSeparator();
                    Scope.getCurrentScope().getUI().sendMessage("WARNING: " + (String)object);
                    Scope.getCurrentScope().getLog(MongoshRunner.class).warning((String)object);
                    throw new LiquibaseException((Throwable)timeoutException);
                    catch (IOException iOException) {
                        IOException iOException2 = iOException;
                        if (iOException.getMessage().contains(EXECUTABLE_NAME)) {
                            throw new LiquibaseException(MSG_UNABLE_TO_RUN_MONGOSH, (Throwable)iOException2);
                        }
                        throw new LiquibaseException((Throwable)iOException2);
                    }
                    catch (Exception exception) {
                        throw new LiquibaseException((Throwable)exception);
                    }
                }
                catch (Throwable throwable) {
                    if (this.outFile != null && this.outFile.exists() && this.keepTempFile != null && this.keepTempFile.booleanValue()) {
                        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Mongosh run script can be located at: " + this.outFile.getAbsolutePath());
                    }
                    throw throwable;
                }
            }
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Mongosh run script can be located at: " + this.outFile.getAbsolutePath());
            return;
        }
    }

    private void loadMongoshProperties() {
        this.setExecutable(NativeRunnerUtil.getExecutable((String)EXECUTABLE_NAME));
        Properties properties = this.getPropertiesFromConf(MONGOSH_CONF);
        this.setupConfProperties(properties);
        this.assignPropertiesFromConfiguration();
        MongoshRunner mongoshRunner = this;
        mongoshRunner.handleMongoShExecutable(mongoshRunner.mongoshExec);
        MongoshRunner mongoshRunner2 = this;
        mongoshRunner2.handleTimeout(mongoshRunner2.timeout);
        this.logProperties();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties getPropertiesFromConf(String string) {
        Properties properties = new Properties();
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        InputStream inputStream = null;
        try {
            resourceAccessor = resourceAccessor.get(string);
            if (!resourceAccessor.exists()) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info(String.format("No configuration file named '%s' found.", string));
            } else {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info(String.format("%s configuration file located at '%s'.", string, resourceAccessor.getUri()));
                inputStream = resourceAccessor.openInputStream();
                properties.load(inputStream);
            }
        }
        catch (IOException iOException) {
            try {
                throw new UnexpectedLiquibaseException((Throwable)iOException);
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            if (inputStream == null) return properties;
            inputStream.close();
            return properties;
        }
        catch (Exception exception) {
            return properties;
        }
    }

    private int determineTimeout(Properties object) {
        if ((object = ((Properties)object).getProperty("liquibase.mongosh.timeout")) == null) {
            return -1;
        }
        try {
            return Integer.parseInt((String)object);
        }
        catch (Exception exception) {
            throw new UnexpectedLiquibaseException("Invalid value '" + (String)object + "' for property 'liquibase.mongosh.timeout'. Must be a valid integer. Learn more at https://docs.liquibase.com/mongodb");
        }
    }

    private void logProperties() {
        if (this.keepTempFile != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'mongosh' with a keep temp file value of '" + this.keepTempFile + "'");
        }
        if (this.tempPath != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'mongosh' with a keep temp file path value of '" + this.tempPath + "'");
        }
        if (this.tempName != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'mongosh' with a keep temp file name value of '" + this.tempName + "'");
        }
        if (this.logFile != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'mongosh' with a log file value of '" + this.logFile + "'");
        }
    }

    private void handleArgs(String string) {
        if (string != null) {
            string = string.trim();
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'mongosh' with a extra arguments of '" + string + "'");
            this.args = StringUtil.splitAndTrim((String)string, (String)" ");
        }
    }

    private void handleTimeout(Integer n) {
        if (n != null) {
            NativeRunnerUtil.validateTimeout((Integer)n);
            this.setTimeout(String.valueOf(n));
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'mongosh' with a timeout of '" + n + "'");
        }
    }

    private void handleMongoShExecutable(File file) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            throw new UnexpectedLiquibaseException("The executable for the native executor 'mongosh' cannot be found at path '" + file.getAbsolutePath() + "' as specified in the liquibase.mongosh.conf file, the LIQUIBASE_MONGOSH_* environment variables, or other config locations. Learn more at https://docs.liquibase.com/concepts/advanced/runwith.html and https://docs.liquibase.com/mongodb");
        }
        if (!file.canExecute()) {
            throw new UnexpectedLiquibaseException("The 'mongosh' executable in the liquibase.mongosh.conf file at " + file.getAbsolutePath() + " cannot be executed. Learn more at https://docs.liquibase.com/mongodb");
        }
        try {
            this.setExecutable(file.getCanonicalPath());
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Using the 'mongosh' executable located at:  '" + file.getCanonicalPath() + "'");
            this.mongoshExec = file;
            return;
        }
        catch (IOException iOException) {
            throw new UnexpectedLiquibaseException((Throwable)iOException);
        }
    }

    private void setupConfProperties(Properties properties) {
        if (properties.containsKey(MongoshConfiguration$ConfigurationKeys.getFullKey("keep.temp"))) {
            this.keepTempFile = NativeRunnerUtil.getBooleanFromProperties((Properties)properties, (String)MongoshConfiguration$ConfigurationKeys.getFullKey("keep.temp"));
        }
        if (properties.containsKey(MongoshConfiguration$ConfigurationKeys.getFullKey("keep.temp.name"))) {
            this.tempName = properties.getProperty(MongoshConfiguration$ConfigurationKeys.getFullKey("keep.temp.name"));
        }
        if (properties.containsKey(MongoshConfiguration$ConfigurationKeys.getFullKey("keep.temp.path"))) {
            this.tempPath = properties.getProperty(MongoshConfiguration$ConfigurationKeys.getFullKey("keep.temp.path"));
        }
        if (properties.containsKey(MongoshConfiguration$ConfigurationKeys.getFullKey("logFile"))) {
            this.logFile = properties.getProperty(MongoshConfiguration$ConfigurationKeys.getFullKey("logFile"));
        }
        if (properties.containsKey("liquibase.mongosh.path")) {
            this.mongoshExec = new File(properties.getProperty("liquibase.mongosh.path"));
        }
        if (properties.containsKey("liquibase.mongosh.timeout")) {
            this.timeout = this.determineTimeout(properties);
        }
        if (properties.containsKey("liquibase.mongosh.args")) {
            this.handleArgs(properties.getProperty("liquibase.mongosh.args"));
        }
    }

    private void assignPropertiesFromConfiguration() {
        this.keepTempFile = MongoshConfiguration.TEMP_KEEP.getCurrentValue() != null ? (Boolean)MongoshConfiguration.TEMP_KEEP.getCurrentValue() : this.keepTempFile;
        this.tempName = MongoshConfiguration.TEMP_NAME.getCurrentValue() != null ? (String)MongoshConfiguration.TEMP_NAME.getCurrentValue() : this.tempName;
        this.tempPath = MongoshConfiguration.TEMP_PATH.getCurrentValue() != null ? (String)MongoshConfiguration.TEMP_PATH.getCurrentValue() : this.tempPath;
        this.logFile = MongoshConfiguration.LOG_FILE.getCurrentValue() != null ? (String)MongoshConfiguration.LOG_FILE.getCurrentValue() : this.logFile;
        Integer n = this.timeout = MongoshConfiguration.TIMEOUT.getCurrentValue() != null ? (Integer)MongoshConfiguration.TIMEOUT.getCurrentValue() : this.timeout;
        if (MongoshConfiguration.PATH.getCurrentValue() != null) {
            this.mongoshExec = new File((String)MongoshConfiguration.PATH.getCurrentValue());
        }
        if (MongoshConfiguration.ARGS.getCurrentValue() != null) {
            this.handleArgs((String)MongoshConfiguration.ARGS.getCurrentValue());
        }
    }
}

