/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.change;

import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.mongodb.change.AbstractMongoChange;
import liquibase.ext.mongodb.statement.DropCollectionStatement;
import liquibase.statement.SqlStatement;
import lombok.Generated;

@DatabaseChange(name="dropCollection", description="Removes a collection or view from the database https://docs.mongodb.com/manual/reference/method/db.collection.drop/#db-collection-drop", priority=1, appliesTo={"collection"})
public class DropCollectionChange
extends AbstractMongoChange {
    private String collectionName;

    public String getConfirmationMessage() {
        return "Collection " + this.getCollectionName() + " dropped";
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new DropCollectionStatement(this.collectionName)};
    }

    @Generated
    public DropCollectionChange() {
    }

    @Generated
    public String getCollectionName() {
        return this.collectionName;
    }

    @Generated
    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }
}

