/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.statement;

import com.mongodb.MongoException;
import com.mongodb.client.MongoDatabase;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import liquibase.Scope;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.ext.mongodb.statement.AbstractMongoStatement;
import liquibase.ext.mongodb.statement.BsonUtils;
import liquibase.nosql.executor.NoSqlExecutor;
import liquibase.nosql.statement.NoSqlExecuteStatement;
import lombok.Generated;
import org.bson.Document;

public abstract class AbstractRunCommandStatement
extends AbstractMongoStatement
implements NoSqlExecuteStatement<MongoLiquibaseDatabase> {
    public static final String COMMAND_NAME = "runCommand";
    public static final String SHELL_DB_PREFIX = "db.";
    public static final String OK = "ok";
    public static final String WRITE_ERRORS = "writeErrors";
    public static final String N = "n";
    public static final String N_MODIFIED = "nModified";
    public static final String N_REMOVED = "nRemoved";
    protected final Document command;

    @Override
    public void execute(MongoLiquibaseDatabase database) {
        Document response = this.run(database);
        this.updateRowsAffected(response);
    }

    public Document run(MongoLiquibaseDatabase database) {
        return this.run(database.getMongoDatabase());
    }

    public Document run(MongoDatabase mongoDatabase) {
        Document response = mongoDatabase.runCommand(this.command);
        this.checkResponse(response);
        return response;
    }

    protected void checkResponse(Document responseDocument) throws MongoException {
        double ok = responseDocument.get(OK) instanceof Integer ? (double)responseDocument.getInteger(OK).intValue() : responseDocument.getDouble(OK);
        List<Document> writeErrors = responseDocument.getList(WRITE_ERRORS, Document.class);
        if (ok != 1.0 || Objects.nonNull(writeErrors) && !writeErrors.isEmpty()) {
            throw new MongoException("Command failed. The full response is " + responseDocument.toJson());
        }
    }

    protected void updateRowsAffected(Document response) {
        Boolean shouldUpdate;
        int affectedCount = this.extractAffectedCount(response);
        if (affectedCount <= 0) {
            return;
        }
        AtomicInteger scopeRowsAffected = (AtomicInteger)Scope.getCurrentScope().get("rowsAffected", AtomicInteger.class);
        if (scopeRowsAffected == null) {
            scopeRowsAffected = NoSqlExecutor.GLOBAL_ROWS_AFFECTED;
        }
        if (Boolean.TRUE.equals(shouldUpdate = (Boolean)Scope.getCurrentScope().get("shouldUpdateRowsAffected", (Object)Boolean.TRUE))) {
            scopeRowsAffected.addAndGet(affectedCount);
            Scope.getCurrentScope().getLog(this.getClass()).fine("Added " + affectedCount + " to ROWS_AFFECTED_SCOPE_KEY; new total=" + scopeRowsAffected.get());
        }
    }

    protected int extractAffectedCount(Document response) {
        if (response.containsKey(N)) {
            return response.getInteger(N, 0);
        }
        if (response.containsKey(N_MODIFIED)) {
            return response.getInteger(N_MODIFIED, 0);
        }
        if (response.containsKey(N_REMOVED)) {
            return response.getInteger(N_REMOVED, 0);
        }
        return 0;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    public abstract String getRunCommandName();

    @Override
    public String toJs() {
        return SHELL_DB_PREFIX + this.getCommandName() + "(" + BsonUtils.toJson(this.command) + ");";
    }

    @Generated
    public AbstractRunCommandStatement(Document command) {
        this.command = command;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractRunCommandStatement)) {
            return false;
        }
        AbstractRunCommandStatement other = (AbstractRunCommandStatement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Document this$command = this.getCommand();
        Document other$command = other.getCommand();
        return !(this$command == null ? other$command != null : !((Object)this$command).equals(other$command));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractRunCommandStatement;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Document $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : ((Object)$command).hashCode());
        return result;
    }

    @Generated
    public Document getCommand() {
        return this.command;
    }
}

