/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.statement;

import com.mongodb.DBRefCodecProvider;
import com.mongodb.MongoClientSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import liquibase.util.StringUtil;
import lombok.Generated;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.DocumentCodecProvider;
import org.bson.codecs.IterableCodecProvider;
import org.bson.codecs.UuidCodec;
import org.bson.codecs.UuidCodecProvider;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;

public final class BsonUtils {
    public static final DocumentCodec DOCUMENT_CODEC = new DocumentCodec(CodecRegistries.fromProviders(new UuidCodecProvider(UuidRepresentation.STANDARD), new ValueCodecProvider(), new BsonValueCodecProvider(), new DocumentCodecProvider(), new DBRefCodecProvider(), new IterableCodecProvider()));
    public static final String ITEMS = "items";

    public static CodecRegistry uuidCodecRegistry() {
        return CodecRegistries.fromRegistries(CodecRegistries.fromCodecs(new UuidCodec(UuidRepresentation.STANDARD)), MongoClientSettings.getDefaultCodecRegistry());
    }

    public static Document orEmptyDocument(String json) {
        return Optional.ofNullable(StringUtil.trimToNull((String)json)).map(s -> Document.parse(s, DOCUMENT_CODEC)).orElseGet(Document::new);
    }

    public static List<Document> orEmptyList(String json) {
        return Optional.ofNullable(StringUtil.trimToNull((String)json)).map(jn -> "{ items: " + jn + "}").map(s -> Document.parse(s, DOCUMENT_CODEC)).map(d -> d.getList(ITEMS, Document.class, new ArrayList())).orElseGet(ArrayList::new);
    }

    public static String toJson(Document document) {
        return Optional.ofNullable(document).map(Document::toJson).orElse(null);
    }

    public static Document toCommand(String commandName, Object commandValue, Document options) {
        Document command = new Document(commandName, commandValue);
        if (Objects.nonNull(options)) {
            command.putAll(options);
        }
        return command;
    }

    @Generated
    private BsonUtils() {
    }
}

