/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.statement;

import java.util.Objects;
import java.util.Optional;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.ext.mongodb.statement.AbstractCollectionStatement;
import liquibase.nosql.statement.NoSqlQueryForLongStatement;
import lombok.Generated;
import org.bson.conversions.Bson;

public class CountDocumentsInCollectionStatement
extends AbstractCollectionStatement
implements NoSqlQueryForLongStatement<MongoLiquibaseDatabase> {
    public static final String COMMAND_NAME = "countDocuments";
    private final Bson filter;

    public CountDocumentsInCollectionStatement(String collectionName) {
        this(collectionName, null);
    }

    public CountDocumentsInCollectionStatement(String collectionName, Bson filter) {
        super(collectionName);
        this.filter = filter;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String toJs() {
        return "db." + this.getCollectionName() + "." + this.getCommandName() + "(" + (String)Optional.ofNullable(this.filter).map(Objects::toString).orElse(null) + ");";
    }

    @Override
    public long queryForLong(MongoLiquibaseDatabase database) {
        return database.getMongoDatabase().getCollection(this.getCollectionName()).countDocuments(this.filter);
    }

    @Generated
    public Bson getFilter() {
        return this.filter;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CountDocumentsInCollectionStatement)) {
            return false;
        }
        CountDocumentsInCollectionStatement other = (CountDocumentsInCollectionStatement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Bson this$filter = this.getFilter();
        Bson other$filter = other.getFilter();
        return !(this$filter == null ? other$filter != null : !this$filter.equals(other$filter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CountDocumentsInCollectionStatement;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Bson $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        return result;
    }
}

