/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.statement;

import java.util.Objects;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.ext.mongodb.statement.AbstractRunCommandStatement;
import liquibase.ext.mongodb.statement.BsonUtils;
import liquibase.nosql.statement.NoSqlUpdateStatement;
import lombok.Generated;
import org.bson.Document;
import org.bson.conversions.Bson;

public class FindOneAndUpdateStatement
extends AbstractRunCommandStatement
implements NoSqlUpdateStatement<MongoLiquibaseDatabase> {
    public static final String RUN_COMMAND_NAME = "findAndModify";
    public static final String QUERY = "query";
    public static final String UPDATE = "update";
    public static final String SORT = "sort";
    public static final String VALUE = "value";

    public FindOneAndUpdateStatement(String collectionName, Bson filter, Bson document, Bson sort) {
        this(collectionName, FindOneAndUpdateStatement.combine(filter, document, sort));
    }

    public FindOneAndUpdateStatement(String collectionName, Document options) {
        super(BsonUtils.toCommand(RUN_COMMAND_NAME, collectionName, options));
    }

    @Override
    public String getRunCommandName() {
        return RUN_COMMAND_NAME;
    }

    private static Document combine(Bson filter, Bson document, Bson sort) {
        Document combined = new Document(QUERY, filter);
        if (Objects.nonNull(document)) {
            combined.put(UPDATE, (Object)document);
        }
        if (Objects.nonNull(sort)) {
            combined.put(SORT, (Object)sort);
        }
        return combined;
    }

    @Override
    public int update(MongoLiquibaseDatabase database) {
        Document response = super.run(database);
        return Objects.isNull(response.get(VALUE)) ? 0 : 1;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindOneAndUpdateStatement)) {
            return false;
        }
        FindOneAndUpdateStatement other = (FindOneAndUpdateStatement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FindOneAndUpdateStatement;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

