/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.statement;

import com.mongodb.client.MongoCollection;
import java.util.Optional;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.ext.mongodb.statement.AbstractCollectionStatement;
import liquibase.nosql.statement.NoSqlExecuteStatement;
import liquibase.nosql.statement.NoSqlUpdateStatement;
import lombok.Generated;
import org.bson.Document;
import org.bson.conversions.Bson;

public class UpdateManyStatement
extends AbstractCollectionStatement
implements NoSqlExecuteStatement<MongoLiquibaseDatabase>,
NoSqlUpdateStatement<MongoLiquibaseDatabase> {
    public static final String COMMAND_NAME = "updateMany";
    private final Bson filter;
    private final Bson document;

    public UpdateManyStatement(String collectionName, Bson filter, Bson document) {
        super(collectionName);
        this.filter = filter;
        this.document = document;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String toJs() {
        return "db." + this.getCollectionName() + "." + this.getCommandName() + "(" + (String)Optional.ofNullable(this.filter).map(Object::toString).orElse(null) + ", " + (String)Optional.ofNullable(this.document).map(Object::toString).orElse(null) + ");";
    }

    @Override
    public void execute(MongoLiquibaseDatabase database) {
        this.update(database);
    }

    @Override
    public int update(MongoLiquibaseDatabase database) {
        MongoCollection<Document> collection = database.getMongoDatabase().getCollection(this.getCollectionName());
        return (int)collection.updateMany(this.filter, this.document).getMatchedCount();
    }

    @Generated
    public Bson getFilter() {
        return this.filter;
    }

    @Generated
    public Bson getDocument() {
        return this.document;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateManyStatement)) {
            return false;
        }
        UpdateManyStatement other = (UpdateManyStatement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Bson this$filter = this.getFilter();
        Bson other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
            return false;
        }
        Bson this$document = this.getDocument();
        Bson other$document = other.getDocument();
        return !(this$document == null ? other$document != null : !this$document.equals(other$document));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UpdateManyStatement;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Bson $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        Bson $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : $document.hashCode());
        return result;
    }
}

