/*
 * Decompiled with CFR 0.152.
 */
package liquibase.servicelocator;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import liquibase.Scope;
import liquibase.exception.ServiceNotFoundException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.Logger;
import liquibase.resource.InputStreamList;
import liquibase.servicelocator.DefaultPackageScanClassResolver;
import liquibase.servicelocator.LiquibaseService;
import liquibase.servicelocator.PackageScanClassResolver;
import liquibase.servicelocator.ServiceLocator;
import liquibase.servicelocator.WebSpherePackageScanClassResolver;
import liquibase.util.StringUtils;

public class ClasspathScanningServiceLocator
implements ServiceLocator {
    private final ServiceLocator parentServiceLocator = Scope.getCurrentScope().getServiceLocator();
    private Map<Class, List<? extends Object>> objectsBySuperclass = new HashMap<Class, List<? extends Object>>();
    private List<String> packagesToScan;
    private PackageScanClassResolver classResolver = this.createPackageScanClassResolver();

    public ClasspathScanningServiceLocator() {
        this.classResolver.setClassLoaders(new HashSet<ClassLoader>(Collections.singletonList(Scope.getCurrentScope().getClassLoader())));
        this.packagesToScan = this.createPackagesToScanList();
    }

    public int getPriority() {
        return 10;
    }

    protected PackageScanClassResolver createPackageScanClassResolver() {
        if (WebSpherePackageScanClassResolver.isWebSphereClassLoader(this.getClass().getClassLoader())) {
            Scope.getCurrentScope().getLog(this.getClass()).fine("Using WebSphere Specific Class Resolver");
            return new WebSpherePackageScanClassResolver("www.liquibase.org/xml/ns/dbchangelog/dbchangelog-2.0.xsd", this.parentServiceLocator);
        }
        return new DefaultPackageScanClassResolver(this.parentServiceLocator);
    }

    protected List<String> createPackagesToScanList() {
        ArrayList<String> returnList = new ArrayList<String>();
        String packagesToScanSystemProp = System.getProperty("liquibase.scan.packages");
        if (packagesToScanSystemProp != null && (packagesToScanSystemProp = StringUtils.trimToNull((String)packagesToScanSystemProp)) != null) {
            returnList.addAll(Arrays.asList(packagesToScanSystemProp.split(",")));
        } else {
            try {
                InputStreamList manifests = Scope.getCurrentScope().getResourceAccessor().openStreams(null, "META-INF/MANIFEST.MF");
                if (manifests != null) {
                    for (InputStream is : manifests) {
                        Manifest manifest = new Manifest(is);
                        String attributes = StringUtils.trimToNull((String)manifest.getMainAttributes().getValue("Liquibase-Package"));
                        if (attributes != null) {
                            for (String value : attributes.split(",")) {
                                returnList.add(value.toString());
                            }
                        }
                        is.close();
                    }
                }
            }
            catch (IOException e) {
                throw new UnexpectedLiquibaseException((Throwable)e);
            }
            returnList.add("liquibase.change");
            returnList.add("liquibase.changelog");
            returnList.add("liquibase.command");
            returnList.add("liquibase.database");
            returnList.add("liquibase.parser");
            returnList.add("liquibase.precondition");
            returnList.add("liquibase.datatype");
            returnList.add("liquibase.serializer");
            returnList.add("liquibase.sqlgenerator");
            returnList.add("liquibase.executor");
            returnList.add("liquibase.snapshot");
            returnList.add("liquibase.logging");
            returnList.add("liquibase.diff");
            returnList.add("liquibase.structure");
            returnList.add("liquibase.structurecompare");
            returnList.add("liquibase.lockservice");
            returnList.add("liquibase.sdk.database");
            returnList.add("liquibase");
            returnList.add("liquibase.pro");
            returnList.add("com.datical.liquibase");
        }
        return returnList;
    }

    public <T> List<T> findInstances(Class<T> interfaceType) throws ServiceNotFoundException {
        ArrayList allInstances = new ArrayList();
        Logger log = Scope.getCurrentScope().getLog(this.getClass());
        log.fine("ClasspathScanningServiceLocator.findInstances for " + interfaceType.getName());
        for (Object t : this.searchForImplementations(interfaceType)) {
            allInstances.add(t);
        }
        return Collections.unmodifiableList(allInstances);
    }

    private List searchForImplementations(Class requiredInterface) throws ServiceNotFoundException {
        List<? extends Object> existingValue = this.objectsBySuperclass.get(requiredInterface.getName());
        if (existingValue != null) {
            return existingValue;
        }
        Logger log = Scope.getCurrentScope().getLog(this.getClass());
        log.fine("ServiceLocator finding classes matching interface " + requiredInterface.getName());
        ArrayList objects = new ArrayList();
        objects.addAll(this.parentServiceLocator.findInstances(requiredInterface));
        this.classResolver.addClassLoader(Scope.getCurrentScope().getClassLoader(true));
        for (Class<?> clazz : this.classResolver.findImplementations(requiredInterface, this.packagesToScan.toArray(new String[this.packagesToScan.size()]))) {
            if (clazz.getAnnotation(LiquibaseService.class) != null && clazz.getAnnotation(LiquibaseService.class).skip() || Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers()) || clazz.isAnonymousClass() || clazz.isSynthetic() || !Modifier.isPublic(clazz.getModifiers())) continue;
            try {
                boolean objectAlreadyLoaded = false;
                for (Object obj : objects) {
                    if (!obj.getClass().getName().equals(clazz.getName())) continue;
                    log.fine("Parent ServiceLocator already loaded " + clazz.getName());
                    objectAlreadyLoaded = true;
                }
                if (objectAlreadyLoaded) continue;
                clazz.getConstructor(new Class[0]);
                log.fine(clazz.getName() + " matches " + requiredInterface.getName());
                objects.add(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ReflectiveOperationException e) {
                log.info("Can not use " + clazz + " as a Liquibase service because it does not have a no-argument constructor");
            }
            catch (NoClassDefFoundError e) {
                String message = "Can not use " + clazz + " as a Liquibase service because " + e.getMessage().replace("/", ".") + " is not in the classpath";
                if (e.getMessage().startsWith("org/yaml/snakeyaml")) {
                    log.info(message);
                    continue;
                }
                log.warning(message);
            }
        }
        this.objectsBySuperclass.put(requiredInterface, objects);
        return objects;
    }
}

