/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.change;

import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.cosmosdb.change.AbstractCosmosChange;
import liquibase.ext.cosmosdb.statement.CreateContainerStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createContainer", description="Create container https://docs.microsoft.com/en-us/java/api/com.azure.cosmos.cosmosdatabase.createcontainer?view=azure-java-stable\nhttps://docs.microsoft.com/en-us/rest/api/cosmos-db/create-a-collection", priority=1, appliesTo={"container"})
public class CreateContainerChange
extends AbstractCosmosChange {
    private String containerId;
    private String containerProperties;
    private String throughputProperties;
    private Boolean skipExisting;

    public String getConfirmationMessage() {
        return "Container created: " + this.containerId;
    }

    public SqlStatement[] generateStatements(Database database) {
        CreateContainerStatement createContainerStatement = new CreateContainerStatement(this.containerId, this.containerProperties, this.throughputProperties, this.skipExisting);
        return new SqlStatement[]{createContainerStatement};
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getContainerProperties() {
        return this.containerProperties;
    }

    public String getThroughputProperties() {
        return this.throughputProperties;
    }

    public Boolean getSkipExisting() {
        return this.skipExisting;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public void setContainerProperties(String containerProperties) {
        this.containerProperties = containerProperties;
    }

    public void setThroughputProperties(String throughputProperties) {
        this.throughputProperties = throughputProperties;
    }

    public void setSkipExisting(Boolean skipExisting) {
        this.skipExisting = skipExisting;
    }
}

