/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cosmosdb.change;

import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.cosmosdb.change.AbstractCosmosChange;
import liquibase.ext.cosmosdb.statement.CreateStoredProcedureStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createStoredProcedure", description="Create Stored Procedure https://docs.microsoft.com/en-us/java/api/com.azure.cosmos.cosmosscripts.createstoredprocedure?view=azure-java-stable\nhttps://docs.microsoft.com/en-us/rest/api/cosmos-db/create-a-stored-procedure", priority=1, appliesTo={"storedProcedure"})
public class CreateStoredProcedureChange
extends AbstractCosmosChange {
    private String containerId;
    private String procedureProperties;
    private Boolean replaceExisting;

    public String getConfirmationMessage() {
        return "Stored Procedure created for: " + this.containerId;
    }

    public SqlStatement[] generateStatements(Database database) {
        CreateStoredProcedureStatement createStoredProcedureStatement = new CreateStoredProcedureStatement(this.containerId, this.procedureProperties, this.replaceExisting);
        return new SqlStatement[]{createStoredProcedureStatement};
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getProcedureProperties() {
        return this.procedureProperties;
    }

    public Boolean getReplaceExisting() {
        return this.replaceExisting;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public void setProcedureProperties(String procedureProperties) {
        this.procedureProperties = procedureProperties;
    }

    public void setReplaceExisting(Boolean replaceExisting) {
        this.replaceExisting = replaceExisting;
    }
}

